/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.kll.KllDirectCompactFloatsSketch;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketchIterator;
import org.apache.datasketches.kll.KllFloatsSketchSortedView;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public abstract class KllFloatsSketch
extends KllSketch
implements QuantilesFloatsAPI {
    private KllFloatsSketchSortedView kllFloatsSV = null;

    KllFloatsSketch(WritableMemory wmem, MemoryRequestServer memReqSvr) {
        super(KllSketch.SketchType.FLOATS_SKETCH, wmem, memReqSvr);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, boolean updatableMemoryFormat) {
        return KllFloatsSketch.getMaxSerializedSizeBytes(k, n, KllSketch.SketchType.FLOATS_SKETCH, updatableMemoryFormat);
    }

    public static KllFloatsSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        if (KllPreambleUtil.getMemoryUpdatableFormatFlag(srcMem)) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_BE_UPDATABLE_FORMAT);
        }
        return KllHeapFloatsSketch.heapifyImpl(srcMem);
    }

    public static KllFloatsSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectFloatsSketch.newDirectInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllFloatsSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectFloatsSketch.newDirectInstance(200, 8, dstMem, memReqSvr);
    }

    public static KllFloatsSketch newHeapInstance() {
        return new KllHeapFloatsSketch(200, 8);
    }

    public static KllFloatsSketch newHeapInstance(int k) {
        return new KllHeapFloatsSketch(k, 8);
    }

    public static KllFloatsSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem);
        if (memVal.updatableMemFormat) {
            return new KllDirectFloatsSketch((WritableMemory)srcMem, null, memVal);
        }
        return new KllDirectCompactFloatsSketch(srcMem, memVal);
    }

    public static KllFloatsSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem);
        if (memVal.updatableMemFormat) {
            if (!memVal.readOnly) {
                Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
            }
            return new KllDirectFloatsSketch(srcMem, memReqSvr, memVal);
        }
        return new KllDirectCompactFloatsSketch((Memory)srcMem, memVal);
    }

    @Override
    public double[] getCDF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public float getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.getMaxFloatItem();
    }

    @Override
    public float getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.getMinFloatItem();
    }

    @Override
    public QuantilesFloatsAPI.FloatsPartitionBoundaries getPartitionBoundaries(int numEquallyWeighted, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        double[] ranks = QuantilesUtil.equallyWeightedRanks(numEquallyWeighted);
        float[] boundaries = this.getQuantiles(ranks, searchCrit);
        boundaries[0] = this.getMinItem();
        boundaries[boundaries.length - 1] = this.getMaxItem();
        QuantilesFloatsAPI.FloatsPartitionBoundaries fpb = new QuantilesFloatsAPI.FloatsPartitionBoundaries();
        fpb.N = this.getN();
        fpb.ranks = ranks;
        fpb.boundaries = boundaries;
        return fpb;
    }

    @Override
    public double[] getPMF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public float[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int len = ranks.length;
        float[] quantiles = new float[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllFloatsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public float getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public float getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(float[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllFloatsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesFloatsSketchIterator iterator() {
        return new KllFloatsSketchIterator(this.getFloatItemsArray(), this.getLevelsArray(), this.getNumLevels());
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toCompactByteArrayImpl(this);
    }

    @Override
    public void update(float item) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllFloatsHelper.updateFloat(this, item);
        this.kllFloatsSV = null;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="OK in this case.")
    public FloatsSortedView getSortedView() {
        this.refreshSortedView();
        return this.kllFloatsSV;
    }

    void nullSortedView() {
        this.kllFloatsSV = null;
    }

    @Override
    double[] getDoubleItemsArray() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return null;
    }

    @Override
    double getMaxDoubleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Double.NaN;
    }

    @Override
    double getMinDoubleItem() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Double.NaN;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMaxDoubleItem(double item) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMinDoubleItem(double item) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    private final void refreshSortedView() {
        this.kllFloatsSV = this.kllFloatsSV == null ? new KllFloatsSketchSortedView(this) : this.kllFloatsSV;
    }
}

