/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

public class QuantilesHelper {
    public static long convertToPrecedingCummulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal = subtotal + array[i];
            array[i] = subtotal;
            subtotal = newSubtotal;
        }
        return subtotal;
    }

    public static long posOfPhi(double phi, long n) {
        long pos = (long)Math.floor(phi * (double)n);
        return pos == n ? n - 1L : pos;
    }

    public static int chunkContainingPos(long[] wtArr, long pos) {
        int nominalLength = wtArr.length - 1;
        assert (nominalLength > 0);
        long n = wtArr[nominalLength];
        assert (0L <= pos);
        assert (pos < n);
        boolean l = false;
        int r = nominalLength;
        assert (0 < r);
        assert (wtArr[0] <= pos);
        assert (pos < wtArr[r]);
        return QuantilesHelper.searchForChunkContainingPos(wtArr, pos, 0, r);
    }

    private static int searchForChunkContainingPos(long[] arr, long pos, int l, int r) {
        assert (l < r);
        assert (arr[l] <= pos);
        assert (pos < arr[r]);
        if (l + 1 == r) {
            return l;
        }
        int m = l + (r - l) / 2;
        if (arr[m] <= pos) {
            return QuantilesHelper.searchForChunkContainingPos(arr, pos, m, r);
        }
        return QuantilesHelper.searchForChunkContainingPos(arr, pos, l, m);
    }
}

