/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.util.Comparator;

public class GenericInequalitySearch {
    public static <T> int find(T[] arr, int low, int high, T v, Inequality inequality, Comparator<T> comparator) {
        int lo = low;
        int hi = high - 1;
        while (lo <= hi) {
            int midA = lo + (hi - lo) / 2;
            int ret = GenericInequalitySearch.compare(arr, midA, midA + 1, v, inequality, comparator);
            if (ret == -1) {
                hi = midA - 1;
                continue;
            }
            if (ret == 1) {
                lo = midA + 1;
                continue;
            }
            return GenericInequalitySearch.getIndex(arr, midA, midA + 1, v, inequality, comparator);
        }
        return GenericInequalitySearch.resolve(lo, hi, low, high, inequality);
    }

    private static <T> int compare(T[] arr, int a, int b, T v, Inequality inequality, Comparator<T> comparator) {
        int result = 0;
        switch (inequality) {
            case GE: 
            case LT: {
                result = comparator.compare(v, arr[a]) < 1 ? -1 : (comparator.compare(arr[b], v) < 0 ? 1 : 0);
                break;
            }
            case GT: 
            case LE: {
                result = comparator.compare(v, arr[a]) < 0 ? -1 : (comparator.compare(arr[b], v) < 1 ? 1 : 0);
                break;
            }
            case EQ: {
                result = comparator.compare(v, arr[a]) < 0 ? -1 : (comparator.compare(arr[b], v) < 0 ? 1 : 0);
            }
        }
        return result;
    }

    private static <T> int getIndex(T[] arr, int a, int b, T v, Inequality inequality, Comparator<T> comparator) {
        int result = 0;
        switch (inequality) {
            case LT: 
            case LE: {
                result = a;
                break;
            }
            case GE: 
            case GT: {
                result = b;
                break;
            }
            case EQ: {
                result = comparator.compare(v, arr[a]) == 0 ? a : (comparator.compare(v, arr[b]) == 0 ? b : -1);
            }
        }
        return result;
    }

    private static int resolve(int lo, int hi, int low, int high, Inequality inequality) {
        int result = 0;
        switch (inequality) {
            case LT: {
                result = lo >= high ? high : -1;
                break;
            }
            case LE: {
                result = lo >= high ? high : -1;
                break;
            }
            case EQ: {
                result = -1;
                break;
            }
            case GE: {
                result = hi <= low ? low : -1;
                break;
            }
            case GT: {
                result = hi <= low ? low : -1;
            }
        }
        return result;
    }

    public static enum Inequality {
        LT,
        LE,
        EQ,
        GE,
        GT;

    }
}

