/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.QuickSelect;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;

public class Union<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> qsk_;
    private long thetaLong_;
    private boolean empty_;

    public Union(SummarySetOperations<S> summarySetOps) {
        this(4096, summarySetOps);
    }

    public Union(int nomEntries, SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.qsk_ = new QuickSelectSketch(nomEntries, null);
        this.thetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }

    public CompactSketch<S> union(Sketch<S> tupleSketchA, Sketch<S> tupleSketchB) {
        this.reset();
        this.union(tupleSketchA);
        this.union(tupleSketchB);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    public CompactSketch<S> union(Sketch<S> tupleSketch, org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.reset();
        this.union(tupleSketch);
        this.union(thetaSketch, summary);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    @Deprecated
    public void update(Sketch<S> tupleSketch) {
        this.union(tupleSketch);
    }

    public void union(Sketch<S> tupleSketch) {
        if (tupleSketch == null || tupleSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        if (tupleSketch.thetaLong_ < this.thetaLong_) {
            this.thetaLong_ = tupleSketch.thetaLong_;
        }
        SketchIterator<S> it = tupleSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.getHash(), it.getSummary(), this.summarySetOps_);
        }
        if (this.qsk_.thetaLong_ < this.thetaLong_) {
            this.thetaLong_ = this.qsk_.thetaLong_;
        }
    }

    @Deprecated
    public void update(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.union(thetaSketch, summary);
    }

    public void union(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        if (thetaSketch == null || thetaSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        long thetaIn = thetaSketch.getThetaLong();
        if (thetaIn < this.thetaLong_) {
            this.thetaLong_ = thetaIn;
        }
        HashIterator it = thetaSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.get(), summary.copy(), this.summarySetOps_);
        }
        if (this.qsk_.thetaLong_ < this.thetaLong_) {
            this.thetaLong_ = this.qsk_.thetaLong_;
        }
    }

    public CompactSketch<S> getResult() {
        if (this.empty_) {
            return this.qsk_.compact();
        }
        if (this.thetaLong_ >= this.qsk_.thetaLong_ && this.qsk_.getRetainedEntries() <= this.qsk_.getNominalEntries()) {
            return this.qsk_.compact();
        }
        long theta = Math.min(this.thetaLong_, this.qsk_.thetaLong_);
        int numHashes = 0;
        SketchIterator<S> it = this.qsk_.iterator();
        while (it.next()) {
            if (it.getHash() >= theta) continue;
            ++numHashes;
        }
        if (numHashes == 0) {
            return new CompactSketch(null, null, theta, this.empty_);
        }
        if (numHashes > this.qsk_.getNominalEntries()) {
            long[] hashArr = new long[numHashes];
            SketchIterator<S> it2 = this.qsk_.iterator();
            int i = 0;
            while (it2.next()) {
                long hash = it2.getHash();
                if (hash >= theta) continue;
                hashArr[i++] = hash;
            }
            theta = QuickSelect.select(hashArr, 0, numHashes - 1, this.qsk_.getNominalEntries());
            numHashes = this.qsk_.getNominalEntries();
        }
        Class<?> summaryType = this.qsk_.getSummaryTable().getClass().getComponentType();
        long[] hashArr = new long[numHashes];
        Summary[] summaries = (Summary[])Array.newInstance(summaryType, numHashes);
        SketchIterator<S> it3 = this.qsk_.iterator();
        int i = 0;
        while (it3.next()) {
            long hash = it3.getHash();
            if (hash >= theta) continue;
            hashArr[i] = hash;
            summaries[i] = it3.getSummary().copy();
            ++i;
        }
        return new CompactSketch(hashArr, summaries, theta, this.empty_);
    }

    public void reset() {
        this.qsk_.reset();
        this.thetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }
}

