/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.BinomialBoundsN;
import org.apache.datasketches.Util;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.UpdatableSketch;

public abstract class Sketch<S extends Summary> {
    protected static final byte PREAMBLE_LONGS = 1;
    long thetaLong_;
    boolean empty_ = true;

    Sketch() {
    }

    public abstract CompactSketch<S> compact();

    public double getEstimate() {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return (double)this.getRetainedEntries() / this.getTheta();
    }

    public double getUpperBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getUpperBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.empty_);
    }

    public double getLowerBound(int numStdDev) {
        if (!this.isEstimationMode()) {
            return this.getRetainedEntries();
        }
        return BinomialBoundsN.getLowerBound(this.getRetainedEntries(), this.getTheta(), numStdDev, this.empty_);
    }

    public double getEstimate(int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return (double)numSubsetEntries / this.getTheta();
    }

    public double getLowerBound(int numStdDev, int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return BinomialBoundsN.getLowerBound(numSubsetEntries, this.getTheta(), numStdDev, this.isEmpty());
    }

    public double getUpperBound(int numStdDev, int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return BinomialBoundsN.getUpperBound(numSubsetEntries, this.getTheta(), numStdDev, this.isEmpty());
    }

    public boolean isEmpty() {
        return this.empty_;
    }

    public boolean isEstimationMode() {
        return this.thetaLong_ < Long.MAX_VALUE && !this.isEmpty();
    }

    public abstract int getRetainedEntries();

    public double getTheta() {
        return (double)this.thetaLong_ / 9.223372036854776E18;
    }

    public abstract byte[] toByteArray();

    public abstract SketchIterator<S> iterator();

    public long getThetaLong() {
        return this.thetaLong_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(this.getClass().getSimpleName()).append(" SUMMARY: ").append(Util.LS);
        sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
        sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
        sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
        sb.append("   Theta (double)          : ").append(this.getTheta()).append(Util.LS);
        sb.append("   Theta (long)            : ").append(this.getThetaLong()).append(Util.LS);
        sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
        sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
        sb.append("   Retained Entries        : ").append(this.getRetainedEntries()).append(Util.LS);
        if (this instanceof UpdatableSketch) {
            UpdatableSketch updatable = (UpdatableSketch)this;
            sb.append("   Nominal Entries (k)     : ").append(updatable.getNominalEntries()).append(Util.LS);
            sb.append("   Current Capacity        : ").append(updatable.getCurrentCapacity()).append(Util.LS);
            sb.append("   Resize Factor           : ").append(updatable.getResizeFactor().getValue()).append(Util.LS);
            sb.append("   Sampling Probability (p): ").append(updatable.getSamplingProbability()).append(Util.LS);
        }
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }
}

