/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.Util;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;

public class Intersection<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private boolean empty_;
    private long thetaLong_;
    private final HashTables hashTables_;
    private boolean firstCall_;

    public Intersection(SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.empty_ = false;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTables_ = new HashTables();
        this.firstCall_ = true;
    }

    public CompactSketch<S> intersect(Sketch<S> tupleSketchA, Sketch<S> tupleSketchB) {
        this.reset();
        this.intersect(tupleSketchA);
        this.intersect(tupleSketchB);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    public CompactSketch<S> intersect(Sketch<S> tupleSketch, org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.reset();
        this.intersect(tupleSketch);
        this.intersect(thetaSketch, summary);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    @Deprecated
    public void update(Sketch<S> tupleSketch) {
        this.intersect(tupleSketch);
    }

    public void intersect(Sketch<S> tupleSketch) {
        if (tupleSketch == null) {
            throw new SketchesArgumentException("Sketch must not be null");
        }
        boolean firstCall = this.firstCall_;
        this.firstCall_ = false;
        long thetaLongIn = tupleSketch.getThetaLong();
        int countIn = tupleSketch.getRetainedEntries();
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongIn);
        boolean emptyIn = countIn == 0 && thetaLongIn == Long.MAX_VALUE;
        this.empty_ |= emptyIn;
        if (countIn == 0) {
            this.hashTables_.clear();
            return;
        }
        if (firstCall) {
            Sketch<S> firstSketch = tupleSketch;
            this.hashTables_.fromSketch(firstSketch);
        } else {
            if (this.hashTables_.count_ == 0) {
                return;
            }
            Sketch<S> nextSketch = tupleSketch;
            int maxMatchSize = Math.min(this.hashTables_.count_, nextSketch.getRetainedEntries());
            long[] matchHashArr = new long[maxMatchSize];
            Summary[] matchSummaries = null;
            int matchCount = 0;
            SketchIterator<S> it = nextSketch.iterator();
            Class<?> summaryType = this.hashTables_.summaryTable_.getClass().getComponentType();
            while (it.next()) {
                int index;
                long hash = it.getHash();
                if (hash >= this.thetaLong_ || (index = HashOperations.hashSearch(this.hashTables_.hashTable_, this.hashTables_.lgTableSize_, hash)) < 0) continue;
                Object mySummary = this.hashTables_.summaryTable_[index];
                if (matchSummaries == null) {
                    matchSummaries = (Summary[])Array.newInstance(summaryType, maxMatchSize);
                }
                matchHashArr[matchCount] = hash;
                matchSummaries[matchCount] = this.summarySetOps_.intersection(mySummary, it.getSummary());
                ++matchCount;
            }
            this.hashTables_.fromArrays(matchHashArr, matchSummaries, matchCount);
        }
    }

    @Deprecated
    public void update(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.intersect(thetaSketch, summary);
    }

    public void intersect(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        if (thetaSketch == null) {
            throw new SketchesArgumentException("Sketch must not be null");
        }
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        boolean firstCall = this.firstCall_;
        this.firstCall_ = false;
        long thetaLongIn = thetaSketch.getThetaLong();
        int countIn = thetaSketch.getRetainedEntries(true);
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongIn);
        boolean emptyIn = countIn == 0 && thetaLongIn == Long.MAX_VALUE;
        this.empty_ |= emptyIn;
        if (countIn == 0) {
            this.hashTables_.clear();
            return;
        }
        if (firstCall) {
            org.apache.datasketches.theta.Sketch firstSketch = thetaSketch;
            this.hashTables_.fromSketch(firstSketch, summary);
        } else {
            if (this.hashTables_.count_ == 0) {
                return;
            }
            org.apache.datasketches.theta.Sketch nextSketch = thetaSketch;
            int maxMatchSize = Math.min(this.hashTables_.count_, nextSketch.getRetainedEntries(true));
            long[] matchHashArr = new long[maxMatchSize];
            Summary[] matchSummaries = null;
            int matchCount = 0;
            HashIterator it = thetaSketch.iterator();
            Class<?> summaryType = this.hashTables_.summaryTable_.getClass().getComponentType();
            while (it.next()) {
                int index;
                long hash = it.get();
                if (hash >= this.thetaLong_ || (index = HashOperations.hashSearch(this.hashTables_.hashTable_, this.hashTables_.lgTableSize_, hash)) < 0) continue;
                Object mySummary = this.hashTables_.summaryTable_[index];
                if (matchSummaries == null) {
                    matchSummaries = (Summary[])Array.newInstance(summaryType, maxMatchSize);
                }
                matchHashArr[matchCount] = hash;
                matchSummaries[matchCount] = this.summarySetOps_.intersection((Summary)mySummary, summary.copy());
                ++matchCount;
            }
            this.hashTables_.fromArrays(matchHashArr, matchSummaries, matchCount);
        }
    }

    public CompactSketch<S> getResult() {
        if (this.firstCall_) {
            throw new SketchesStateException("getResult() with no intervening intersections is not a legal result.");
        }
        if (this.hashTables_.count_ == 0) {
            return new CompactSketch(null, null, this.thetaLong_, this.empty_);
        }
        int tableSize = this.hashTables_.hashTable_.length;
        long[] hashArr = new long[this.hashTables_.count_];
        Summary[] summaries = null;
        Class<?> summaryType = this.hashTables_.summaryTable_.getClass().getComponentType();
        int cnt = 0;
        for (int i = 0; i < tableSize; ++i) {
            long hash = this.hashTables_.hashTable_[i];
            if (hash == 0L || hash > this.thetaLong_) continue;
            Object summary = this.hashTables_.summaryTable_[i];
            if (summaries == null) {
                summaries = (Summary[])Array.newInstance(summaryType, this.hashTables_.count_);
            }
            hashArr[cnt] = hash;
            summaries[cnt] = summary;
            ++cnt;
        }
        assert (cnt == this.hashTables_.count_);
        return new CompactSketch(hashArr, summaries, this.thetaLong_, this.empty_);
    }

    public boolean hasResult() {
        return !this.firstCall_;
    }

    public void reset() {
        this.empty_ = false;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTables_.clear();
        this.firstCall_ = true;
    }

    private static int getLgTableSize(int count) {
        int tableSize = Math.max(Util.ceilingPowerOf2((int)Math.ceil((double)count / 0.75)), 16);
        return Integer.numberOfTrailingZeros(tableSize);
    }

    private class HashTables {
        long[] hashTable_ = null;
        S[] summaryTable_ = null;
        int lgTableSize_ = 0;
        int count_ = 0;

        HashTables() {
        }

        void fromSketch(Sketch<S> sketch) {
            this.count_ = sketch.getRetainedEntries();
            this.lgTableSize_ = Intersection.getLgTableSize(this.count_);
            Summary mySummary = null;
            this.hashTable_ = new long[1 << this.lgTableSize_];
            SketchIterator it = sketch.iterator();
            while (it.next()) {
                long hash = it.getHash();
                int index = HashOperations.hashInsertOnly(this.hashTable_, this.lgTableSize_, hash);
                mySummary = it.getSummary().copy();
                if (this.summaryTable_ == null) {
                    this.summaryTable_ = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize_);
                }
                this.summaryTable_[index] = mySummary;
            }
        }

        void fromSketch(org.apache.datasketches.theta.Sketch sketch, S summary) {
            this.count_ = sketch.getRetainedEntries(true);
            this.lgTableSize_ = Intersection.getLgTableSize(this.count_);
            Object mySummary = null;
            this.hashTable_ = new long[1 << this.lgTableSize_];
            HashIterator it = sketch.iterator();
            while (it.next()) {
                long hash = it.get();
                int index = HashOperations.hashInsertOnly(this.hashTable_, this.lgTableSize_, hash);
                mySummary = summary;
                if (this.summaryTable_ == null) {
                    this.summaryTable_ = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize_);
                }
                this.summaryTable_[index] = mySummary;
            }
        }

        void fromArrays(long[] hashArr, S[] summaryArr, int count) {
            this.count_ = count;
            this.lgTableSize_ = Intersection.getLgTableSize(count);
            Object mySummary = null;
            this.summaryTable_ = null;
            this.hashTable_ = new long[1 << this.lgTableSize_];
            for (int i = 0; i < count; ++i) {
                long hash = hashArr[i];
                int index = HashOperations.hashInsertOnly(this.hashTable_, this.lgTableSize_, hash);
                mySummary = summaryArr[i];
                if (this.summaryTable_ == null) {
                    this.summaryTable_ = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize_);
                }
                this.summaryTable_[index] = summaryArr[i];
            }
        }

        void clear() {
            this.hashTable_ = null;
            this.summaryTable_ = null;
            this.lgTableSize_ = 0;
            this.count_ = 0;
        }
    }
}

