/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.ItemsSketch;

public class ItemsSketchIterator<T> {
    private final ItemsSketch<T> sketch_;
    private Object[] combinedBuffer_;
    private long bits_;
    private int level_;
    private long weight_;
    private int i_;
    private int offset_;
    private int num_;

    ItemsSketchIterator(ItemsSketch<T> sketch, long bitPattern) {
        this.sketch_ = sketch;
        this.bits_ = bitPattern;
        this.level_ = -1;
        this.weight_ = 1L;
        this.i_ = 0;
        this.offset_ = 0;
    }

    public boolean next() {
        if (this.combinedBuffer_ == null) {
            this.combinedBuffer_ = this.sketch_.combinedBuffer_;
            this.num_ = this.sketch_.getBaseBufferCount();
        } else {
            ++this.i_;
        }
        if (this.i_ < this.num_) {
            return true;
        }
        do {
            ++this.level_;
            if (this.level_ > 0) {
                this.bits_ >>>= 1;
            }
            if (this.bits_ == 0L) {
                return false;
            }
            this.weight_ *= 2L;
        } while ((this.bits_ & 1L) == 0L);
        this.i_ = 0;
        this.offset_ = (2 + this.level_) * this.sketch_.getK();
        this.num_ = this.sketch_.getK();
        return true;
    }

    public T getValue() {
        return (T)this.combinedBuffer_[this.offset_ + this.i_];
    }

    public long getWeight() {
        return this.weight_;
    }
}

