/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class Union
extends BaseHllSketch {
    final int lgMaxK;
    private final HllSketch gadget;

    public Union() {
        this.lgMaxK = 12;
        this.gadget = new HllSketch(this.lgMaxK, TgtHllType.HLL_8);
    }

    public Union(int lgMaxK) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8);
    }

    public Union(int lgMaxK, WritableMemory dstMem) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8, dstMem);
    }

    Union(HllSketch sketch) {
        this.lgMaxK = sketch.getLgConfigK();
        TgtHllType tgtHllType = sketch.getTgtHllType();
        if (tgtHllType != TgtHllType.HLL_8) {
            throw new SketchesArgumentException("Union can only wrap writable HLL_8 sketches.");
        }
        if (sketch.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            throw new SketchesArgumentException("Incomming sketch is corrupted, Rebuild_CurMin_Num_KxQ flag is set.");
        }
        this.gadget = sketch;
    }

    public static final Union heapify(byte[] byteArray) {
        return Union.heapify(Memory.wrap((byte[])byteArray));
    }

    public static final Union heapify(Memory mem) {
        int lgK = HllUtil.checkLgK(mem.getByte((long)PreambleUtil.LG_K_BYTE));
        HllSketch sk = HllSketch.heapify(mem);
        Union union = new Union(lgK);
        union.update(sk);
        return union;
    }

    public static final Union writableWrap(WritableMemory wmem) {
        return new Union(HllSketch.writableWrap(wmem));
    }

    @Override
    public double getCompositeEstimate() {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.hllSketchImpl.getCompositeEstimate();
    }

    @Override
    CurMode getCurMode() {
        return this.gadget.getCurMode();
    }

    @Override
    public int getCompactSerializationBytes() {
        return this.gadget.getCompactSerializationBytes();
    }

    @Override
    public double getEstimate() {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.getEstimate();
    }

    @Override
    public int getLgConfigK() {
        return this.gadget.getLgConfigK();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.getLowerBound(numStdDev);
    }

    public static int getMaxSerializationBytes(int lgK) {
        return HllSketch.getMaxUpdatableSerializationBytes(lgK, TgtHllType.HLL_8);
    }

    public HllSketch getResult() {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.copyAs(HllSketch.DEFAULT_HLL_TYPE);
    }

    public HllSketch getResult(TgtHllType tgtHllType) {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.copyAs(tgtHllType);
    }

    @Override
    public TgtHllType getTgtHllType() {
        return TgtHllType.HLL_8;
    }

    @Override
    public int getUpdatableSerializationBytes() {
        return this.gadget.getUpdatableSerializationBytes();
    }

    @Override
    public double getUpperBound(int numStdDev) {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.getUpperBound(numStdDev);
    }

    @Override
    public boolean isCompact() {
        return this.gadget.isCompact();
    }

    @Override
    public boolean isEmpty() {
        return this.gadget.isEmpty();
    }

    @Override
    public boolean isMemory() {
        return this.gadget.isMemory();
    }

    @Override
    public boolean isOffHeap() {
        return this.gadget.isOffHeap();
    }

    @Override
    boolean isOutOfOrderFlag() {
        return this.gadget.isOutOfOrderFlag();
    }

    @Override
    public boolean isSameResource(Memory mem) {
        return this.gadget.isSameResource(mem);
    }

    boolean isRebuildCurMinNumKxQFlag() {
        return this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag();
    }

    void putRebuildCurMinNumKxQFlag(boolean rebuild) {
        this.gadget.hllSketchImpl.putRebuildCurMinNumKxQFlag(rebuild);
    }

    @Override
    public void reset() {
        this.gadget.reset();
    }

    @Override
    public byte[] toCompactByteArray() {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.toCompactByteArray();
    }

    @Override
    public byte[] toUpdatableByteArray() {
        if (this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            Union.rebuildCurMinNumKxQ((AbstractHllArray)this.gadget.hllSketchImpl);
        }
        return this.gadget.toUpdatableByteArray();
    }

    @Override
    public String toString(boolean summary, boolean hllDetail, boolean auxDetail, boolean all) {
        return this.gadget.toString(summary, hllDetail, auxDetail, all);
    }

    public void update(HllSketch sketch) {
        if (sketch.hllSketchImpl.isRebuildCurMinNumKxQFlag()) {
            throw new SketchesArgumentException("Incomming sketch is corrupted, Rebuild_CurMin_Num_KxQ flag is set.");
        }
        this.gadget.hllSketchImpl = Union.unionImpl(sketch, this.gadget, this.lgMaxK);
    }

    @Override
    void couponUpdate(int coupon) {
        if (coupon == 0) {
            return;
        }
        this.gadget.hllSketchImpl = this.gadget.hllSketchImpl.couponUpdate(coupon);
    }

    private static HllSketchImpl unionImpl(HllSketch source, HllSketch gadget, int lgMaxK) {
        assert (gadget.getTgtHllType() == TgtHllType.HLL_8);
        if (source == null || source.isEmpty()) {
            return gadget.hllSketchImpl;
        }
        int srcLgK = source.getLgConfigK();
        int gadgetLgK = gadget.getLgConfigK();
        boolean srcIsMem = source.isMemory();
        boolean gdtIsMem = gadget.isMemory();
        if (source.getCurMode() == CurMode.LIST) {
            source.mergeTo(gadget);
            gadget.putOutOfOrderFlag(gadget.isOutOfOrderFlag() | source.isOutOfOrderFlag());
            return gadget.hllSketchImpl;
        }
        if (source.getCurMode() == CurMode.SET) {
            if (gadget.isEmpty() && !srcIsMem && !gdtIsMem && srcLgK == gadgetLgK) {
                gadget.hllSketchImpl = source.copyAs((TgtHllType)TgtHllType.HLL_8).hllSketchImpl;
                return gadget.hllSketchImpl;
            }
            source.mergeTo(gadget);
            gadget.putOutOfOrderFlag(true);
            return gadget.hllSketchImpl;
        }
        int bit0 = gdtIsMem ? 1 : 0;
        int bits1_2 = (gadget.isEmpty() ? 3 : gadget.getCurMode().ordinal()) << 1;
        int bit3 = srcLgK < gadgetLgK ? 8 : 0;
        int bit4 = srcLgK > lgMaxK ? 16 : 0;
        int sw = bit4 | bit3 | bits1_2 | bit0;
        HllSketchImpl hllSketchImpl = null;
        switch (sw) {
            case 0: 
            case 8: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                HllSketch gdtTmp = srcHll8Heap;
                gdtTmp.putOutOfOrderFlag(gdtTmp.isOutOfOrderFlag() | source.isOutOfOrderFlag());
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 1: 
            case 9: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                gdtTmp.putOutOfOrderFlag(gdtTmp.isOutOfOrderFlag() | source.isOutOfOrderFlag());
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 2: 
            case 10: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                HllSketch gdtTmp = srcHll8Heap;
                gdtTmp.putOutOfOrderFlag(true);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 3: 
            case 11: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                gdtTmp.putOutOfOrderFlag(true);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 4: 
            case 5: 
            case 20: 
            case 21: {
                Union.mergeHlltoHLLmode(source, gadget, srcLgK, gadgetLgK, srcIsMem, gdtIsMem);
                gadget.putOutOfOrderFlag(true);
                hllSketchImpl = gadget.hllSketchImpl;
                break;
            }
            case 6: 
            case 14: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 7: 
            case 15: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 12: {
                HllSketch gdtHll8Heap = Union.downsample(gadget, srcLgK);
                Union.mergeHlltoHLLmode(source, gdtHll8Heap, srcLgK, gadgetLgK, srcIsMem, false);
                gdtHll8Heap.putOutOfOrderFlag(true);
                hllSketchImpl = gdtHll8Heap.hllSketchImpl;
                break;
            }
            case 13: {
                HllSketch gdtHll8Heap = Union.downsample(gadget, srcLgK);
                Union.mergeHlltoHLLmode(source, gdtHll8Heap, srcLgK, gadgetLgK, srcIsMem, false);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = gdtHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                gdtTmp.putOutOfOrderFlag(true);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 16: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                HllSketch gdtTmp = srcHll8Heap;
                gdtTmp.putOutOfOrderFlag(gdtTmp.isOutOfOrderFlag() | source.isOutOfOrderFlag());
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 17: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                gdtTmp.putOutOfOrderFlag(gdtTmp.isOutOfOrderFlag() | source.isOutOfOrderFlag());
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 18: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                HllSketch gdtTmp = srcHll8Heap;
                gdtTmp.putOutOfOrderFlag(true);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 19: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                HllSketch gdtTmp = HllSketch.writableWrap(wmem);
                gdtTmp.putOutOfOrderFlag(true);
                hllSketchImpl = gdtTmp.hllSketchImpl;
                break;
            }
            case 22: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 23: {
                HllSketch srcHll8Heap = Union.downsample(source, lgMaxK);
                WritableMemory wmem = gadget.getWritableMemory();
                byte[] byteArr = srcHll8Heap.toUpdatableByteArray();
                wmem.putByteArray(0L, byteArr, 0, byteArr.length);
                hllSketchImpl = HllSketch.writableWrap((WritableMemory)wmem).hllSketchImpl;
                break;
            }
        }
        return hllSketchImpl;
    }

    private static void mergeHlltoHLLmode(HllSketch src, HllSketch tgt, int srcLgK, int tgtLgK, boolean srcIsMem, boolean tgtIsMem) {
        int sw = (tgtIsMem ? 1 : 0) | (srcIsMem ? 2 : 0) | (srcLgK > tgtLgK ? 4 : 0) | (src.getTgtHllType() != TgtHllType.HLL_8 ? 8 : 0);
        switch (sw) {
            case 0: {
                int srcK = 1 << srcLgK;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    byte tgtV = tgtArr[i];
                    tgtArr[i] = srcV > tgtV ? srcV : tgtV;
                }
                break;
            }
            case 1: {
                int srcK = 1 << srcLgK;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                WritableMemory tgtMem = tgt.getWritableMemory();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    byte tgtV = tgtMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtMem.putByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i), srcV > tgtV ? srcV : tgtV);
                }
                break;
            }
            case 2: {
                int srcK = 1 << srcLgK;
                Memory srcMem = src.getMemory();
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte tgtV;
                    byte srcV = srcMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtArr[i] = srcV > (tgtV = tgtArr[i]) ? srcV : tgtV;
                }
                break;
            }
            case 3: {
                int srcK = 1 << srcLgK;
                Memory srcMem = src.getMemory();
                WritableMemory tgtMem = tgt.getWritableMemory();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    byte tgtV = tgtMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtMem.putByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i), srcV > tgtV ? srcV : tgtV);
                }
                break;
            }
            case 4: {
                int srcK = 1 << srcLgK;
                int tgtKmask = (1 << tgtLgK) - 1;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    int j = i & tgtKmask;
                    byte tgtV = tgtArr[j];
                    tgtArr[j] = srcV > tgtV ? srcV : tgtV;
                }
                break;
            }
            case 5: {
                int srcK = 1 << srcLgK;
                int tgtKmask = (1 << tgtLgK) - 1;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                WritableMemory tgtMem = tgt.getWritableMemory();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    int j = i & tgtKmask;
                    byte tgtV = tgtMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + j));
                    tgtMem.putByte((long)(PreambleUtil.HLL_BYTE_ARR_START + j), srcV > tgtV ? srcV : tgtV);
                }
                break;
            }
            case 6: {
                int srcK = 1 << srcLgK;
                int tgtKmask = (1 << tgtLgK) - 1;
                Memory srcMem = src.getMemory();
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    int j;
                    byte tgtV;
                    byte srcV = srcMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtArr[j] = srcV > (tgtV = tgtArr[j = i & tgtKmask]) ? srcV : tgtV;
                }
                break;
            }
            case 7: {
                int srcK = 1 << srcLgK;
                int tgtKmask = (1 << tgtLgK) - 1;
                Memory srcMem = src.getMemory();
                WritableMemory tgtMem = tgt.getWritableMemory();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    int j = i & tgtKmask;
                    byte tgtV = tgtMem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + j));
                    tgtMem.putByte((long)(PreambleUtil.HLL_BYTE_ARR_START + j), srcV > tgtV ? srcV : tgtV);
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int srcK = 1 << srcLgK;
                AbstractHllArray srcAbsHllArr = (AbstractHllArray)src.hllSketchImpl;
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                for (int i = 0; i < srcK; ++i) {
                    int srcV = srcAbsHllArr.getSlotValue(i);
                    tgtAbsHllArr.updateSlotNoKxQ(i, srcV);
                }
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                int srcK = 1 << srcLgK;
                int tgtKmask = (1 << tgtLgK) - 1;
                AbstractHllArray srcAbsHllArr = (AbstractHllArray)src.hllSketchImpl;
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                for (int i = 0; i < srcK; ++i) {
                    int srcV = srcAbsHllArr.getSlotValue(i);
                    int j = i & tgtKmask;
                    tgtAbsHllArr.updateSlotNoKxQ(j, srcV);
                }
                break;
            }
        }
        tgt.hllSketchImpl.putRebuildCurMinNumKxQFlag(true);
    }

    private static final HllSketch downsample(HllSketch candidate, int tgtLgK) {
        AbstractHllArray candArr = (AbstractHllArray)candidate.hllSketchImpl;
        HllArray tgtHllArr = HllArray.newHeapHll(tgtLgK, TgtHllType.HLL_8);
        PairIterator candItr = candArr.iterator();
        while (candItr.nextValid()) {
            tgtHllArr.couponUpdate(candItr.getPair());
        }
        tgtHllArr.putHipAccum(candArr.getHipAccum());
        tgtHllArr.putOutOfOrderFlag(candidate.isOutOfOrderFlag());
        tgtHllArr.putRebuildCurMinNumKxQFlag(false);
        return new HllSketch(tgtHllArr);
    }

    private static final void rebuildCurMinNumKxQ(AbstractHllArray absHllArr) {
        int curMin = 64;
        int numAtCurMin = 0;
        double kxq0 = 1 << absHllArr.getLgConfigK();
        double kxq1 = 0.0;
        PairIterator itr = absHllArr.iterator();
        while (itr.nextAll()) {
            int v = itr.getValue();
            if (v > 0) {
                if (v < 32) {
                    kxq0 += Util.invPow2(v) - 1.0;
                } else {
                    kxq1 += Util.invPow2(v) - 1.0;
                }
            }
            if (v > curMin) continue;
            if (v < curMin) {
                curMin = v;
                numAtCurMin = 1;
                continue;
            }
            ++numAtCurMin;
        }
        absHllArr.putKxQ0(kxq0);
        absHllArr.putKxQ1(kxq1);
        absHllArr.putCurMin(curMin);
        absHllArr.putNumAtCurMin(numAtCurMin);
        absHllArr.putRebuildCurMinNumKxQFlag(false);
    }
}

