/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class UnionSketchUDF
extends UDF {
    private static final int EMPTY_SKETCH_SIZE_BYTES = 8;

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int sketchSize, long seed) {
        Union union = SetOperation.builder().setSeed(seed).setNominalEntries(sketchSize).buildUnion();
        if (firstSketch != null && firstSketch.getLength() >= 8) {
            union.union(BytesWritableHelper.wrapAsMemory(firstSketch));
        }
        if (secondSketch != null && secondSketch.getLength() >= 8) {
            union.union(BytesWritableHelper.wrapAsMemory(secondSketch));
        }
        return new BytesWritable(union.getResult().toByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int sketchSize) {
        return this.evaluate(firstSketch, secondSketch, sketchSize, 9001L);
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch) {
        return this.evaluate(firstSketch, secondSketch, 4096, 9001L);
    }
}

