/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class EstimateSketchUDF
extends UDF {
    private static final int EMPTY_SKETCH_SIZE_BYTES = 8;

    public Double evaluate(BytesWritable binarySketch) {
        return this.evaluate(binarySketch, 9001L);
    }

    public Double evaluate(BytesWritable binarySketch, long seed) {
        if (binarySketch == null) {
            return 0.0;
        }
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory(binarySketch);
        if (serializedSketch.getCapacity() <= 8L) {
            return 0.0;
        }
        return Sketch.wrap((Memory)serializedSketch, (long)seed).getEstimate();
    }
}

