/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.ItemsUnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

abstract class ItemsEvaluator<T>
extends GenericUDAFEvaluator {
    private final Comparator<? super T> comparator_;
    private final ArrayOfItemsSerDe<T> serDe_;
    protected PrimitiveObjectInspector inputObjectInspector;
    protected PrimitiveObjectInspector kObjectInspector;

    ItemsEvaluator(Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        this.comparator_ = comparator;
        this.serDe_ = serDe;
    }

    public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
        super.init(mode, parameters);
        this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
        if ((mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) && parameters.length > 1) {
            this.kObjectInspector = (PrimitiveObjectInspector)parameters[1];
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ItemsUnionState state = (ItemsUnionState)buf;
        state.reset();
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        return this.terminate(buf);
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        ItemsUnionState state = (ItemsUnionState)buf;
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.inputObjectInspector.getPrimitiveWritableObject(data));
        state.update(serializedSketch);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ItemsUnionState state = (ItemsUnionState)buf;
        ItemsSketch resultSketch = state.getResult();
        if (resultSketch == null) {
            return null;
        }
        return new BytesWritable(resultSketch.toByteArray(this.serDe_));
    }

    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new ItemsUnionState<T>(this.comparator_, this.serDe_);
    }
}

