/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetPMF", value="_FUNC_(sketch, split points...)", extended="Returns an approximation to the Probability Mass Function (PMF) from a sketch given a set of split points (values). Split points are an array of M unique, monotonically increasing values that divide the domain into M+1 consecutive disjoint intervals. The function returns an array of M+1 doubles, each of which is an approximation to the fraction of the values that fell into one of those intervals. The definition of an interval is inclusive of the left split point and exclusive of the right split point")
public class GetPmfFromStringsSketchUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch, String ... splitPoints) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        double[] pmf = sketch.getPMF((Object[])splitPoints);
        if (pmf == null) {
            return null;
        }
        return Util.primitivesToList(pmf);
    }
}

