/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.hll.SketchEvaluator;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class UnionSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK, String type) {
        TgtHllType hllType = TgtHllType.valueOf((String)type);
        Union union = new Union(lgK);
        if (firstSketch != null) {
            union.update(HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketch)));
        }
        if (secondSketch != null) {
            union.update(HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketch)));
        }
        return new BytesWritable(union.getResult(hllType).toCompactByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK) {
        return this.evaluate(firstSketch, secondSketch, lgK, SketchEvaluator.DEFAULT_HLL_TYPE.toString());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch) {
        return this.evaluate(firstSketch, secondSketch, 12, SketchEvaluator.DEFAULT_HLL_TYPE.toString());
    }
}

