/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.layers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.runtime1.layers.ChecksumLayerBase;
import org.apache.daffodil.runtime1.layers.LayerNotEnoughDataException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2Aa\u0002\u0005\u0001'!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u0015\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0011\u00159\u0003\u0001\"\u0003)\u0011!!\u0004\u0001#b\u0001\n\u0013)\u0004\"B\u001d\u0001\t\u0003R$AG\"iK\u000e\\7/^7EK\u000e|G-\u001a:J]B,Ho\u0015;sK\u0006l'BA\u0005\u000b\u0003\u0019a\u0017-_3sg*\u00111\u0002D\u0001\teVtG/[7fc)\u0011QBD\u0001\tI\u00064gm\u001c3jY*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012AA5p\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0006Y\u0006LXM\u001d\t\u0003=}i\u0011\u0001C\u0005\u0003A!\u0011\u0011c\u00115fG.\u001cX/\u001c'bs\u0016\u0014()Y:f\u0003\rQ\u0017n]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0011*c\u0005\u0005\u0002\u001f\u0001!)Ad\u0001a\u0001;!)\u0011e\u0001a\u0001)\u0005\tBm\\;cY\u0016\u001c\u0005.Z2l\u0019\u0016tw\r\u001e5\u0015\u0005%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#\u0001B+oSRDQ\u0001\r\u0003A\u0002E\nQ\"Y2uk\u0006dG)\u0019;b\u0019\u0016t\u0007C\u0001\u00163\u0013\t\u00194FA\u0002J]R\fAAY1jgV\ta\u0007\u0005\u0002\u0016o%\u0011\u0001H\u0006\u0002\u0015\u0005f$X-\u0011:sCfLe\u000e];u'R\u0014X-Y7\u0002\tI,\u0017\r\u001a\u000b\u0002c\u0001")
public class ChecksumDecoderInputStream
extends InputStream {
    private ByteArrayInputStream bais;
    private final ChecksumLayerBase layer;
    private final InputStream jis;
    private volatile boolean bitmap$0;

    private void doubleCheckLength(int actualDataLen) {
        int neededLen = this.layer.getLength();
        if (neededLen > actualDataLen) {
            this.layer.processingError(new LayerNotEnoughDataException(neededLen, actualDataLen));
            return;
        }
    }

    private ByteArrayInputStream bais$lzycompute() {
        ChecksumDecoderInputStream checksumDecoderInputStream = this;
        synchronized (checksumDecoderInputStream) {
            if (!this.bitmap$0) {
                byte[] ba = new byte[this.layer.getLength()];
                int nRead = IOUtils.read((InputStream)this.jis, (byte[])ba);
                this.doubleCheckLength(nRead);
                ByteBuffer buf = ByteBuffer.wrap(ba);
                this.layer.setChecksum(this.layer.compute(false, buf));
                this.bais = new ByteArrayInputStream(ba);
                this.bitmap$0 = true;
            }
        }
        return this.bais;
    }

    private ByteArrayInputStream bais() {
        if (!this.bitmap$0) {
            return this.bais$lzycompute();
        }
        return this.bais;
    }

    @Override
    public int read() {
        return this.bais().read();
    }

    public ChecksumDecoderInputStream(ChecksumLayerBase layer, InputStream jis) {
        this.layer = layer;
        this.jis = jis;
    }
}

