/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.httpservice;

import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.dosgi.common.httpservice.Chain;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityDelegatingHttpContext
implements HttpContext {
    public static final String FILTER_PROP = "org.apache.cxf.httpservice.filter";
    public static final String FILTER_REQUIRED_PROP = "org.apache.cxf.httpservice.requirefilter";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityDelegatingHttpContext.class);
    private static final String FILTER_FILTER = "(org.apache.cxf.httpservice.filter=*)";
    BundleContext bundleContext;
    HttpContext delegate;
    boolean requireFilter;

    SecurityDelegatingHttpContext(BundleContext bundleContext, HttpContext delegate) {
        this.bundleContext = bundleContext;
        this.delegate = delegate;
        this.requireFilter = Boolean.TRUE.toString().equalsIgnoreCase(bundleContext.getProperty(FILTER_REQUIRED_PROP));
    }

    public String getMimeType(String name) {
        return this.delegate.getMimeType(name);
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServiceReference[] refs;
        try {
            refs = this.bundleContext.getServiceReferences(Filter.class.getName(), FILTER_FILTER);
        }
        catch (InvalidSyntaxException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        if (refs == null || refs.length == 0) {
            LOG.info("No filter registered.");
            return !this.requireFilter;
        }
        Filter[] filters = new Filter[refs.length];
        try {
            boolean i;
            for (i = false; i < refs.length; i += 1) {
                filters[i] = (Filter)this.bundleContext.getService(refs[i]);
            }
            try {
                new Chain(filters).doFilter((ServletRequest)request, (ServletResponse)response);
                i = !response.isCommitted();
                return i;
            }
            catch (ServletException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                boolean bl = false;
                for (int i2 = 0; i2 < refs.length; ++i2) {
                    if (filters[i2] == null) continue;
                    this.bundleContext.ungetService(refs[i2]);
                }
                return bl;
            }
        }
        finally {
            for (int i = 0; i < refs.length; ++i) {
                if (filters[i] == null) continue;
                this.bundleContext.ungetService(refs[i]);
            }
        }
    }
}

