/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.common.httpservice;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.dosgi.common.httpservice.SecurityDelegatingHttpContext;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.cxf.dosgi.http", service={HttpServiceManager.class})
public class HttpServiceManager {
    public static final String KEY_HTTP_BASE = "httpBase";
    public static final String KEY_CXF_SERVLET_ALIAS = "cxfServletAlias";
    public static final String DEFAULT_CXF_SERVLET_ALIAS = "/cxf";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceManager.class);
    private Map<Long, String> exportedAliases = Collections.synchronizedMap(new HashMap());
    private String httpBase;
    private String cxfServletAlias;
    private HttpService httpService;
    private BundleContext context;

    @Activate
    public void activate(ComponentContext compContext) {
        Dictionary config = compContext.getProperties();
        this.initFromConfig(config);
        this.context = compContext.getBundleContext();
    }

    public void initFromConfig(Dictionary<String, Object> config) {
        if (config == null) {
            config = new Hashtable<String, Object>();
        }
        this.httpBase = this.getWithDefault(config.get(KEY_HTTP_BASE), "http://localhost:8181");
        this.cxfServletAlias = this.getWithDefault(config.get(KEY_CXF_SERVLET_ALIAS), DEFAULT_CXF_SERVLET_ALIAS);
    }

    private String getWithDefault(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    public Bus registerServlet(Bus bus, String contextRoot, BundleContext callingContext, Long sid) {
        bus.setExtension((Object)new DestinationRegistryImpl(), DestinationRegistry.class);
        CXFNonSpringServlet cxf = new CXFNonSpringServlet();
        cxf.setBus(bus);
        try {
            HttpContext httpContext1 = this.httpService.createDefaultHttpContext();
            SecurityDelegatingHttpContext httpContext = new SecurityDelegatingHttpContext(callingContext, httpContext1);
            this.httpService.registerServlet(contextRoot, (Servlet)cxf, new Hashtable(), (HttpContext)httpContext);
            this.registerUnexportHook(sid, contextRoot);
            LOG.info("Successfully registered CXF DOSGi servlet at " + contextRoot);
        }
        catch (Exception e) {
            throw new ServiceException("CXF DOSGi: problem registering CXF HTTP Servlet", (Throwable)e);
        }
        return bus;
    }

    private void registerUnexportHook(Long sid, String alias) {
        LOG.debug("Registering service listener for service with ID {}", (Object)sid);
        String previous = this.exportedAliases.put(sid, alias);
        if (previous != null) {
            LOG.warn("Overwriting service export for service with ID {}", (Object)sid);
        }
        try {
            Filter f = this.context.createFilter("(service.id=" + sid + ")");
            if (f != null) {
                this.context.addServiceListener((ServiceListener)new UnregisterListener(), f.toString());
            } else {
                LOG.warn("Service listener could not be started. The service will not be automatically unexported.");
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.warn("Service listener could not be started. The service will not be automatically unexported.", (Throwable)e);
        }
    }

    public String getDefaultAddress(Class<?> type) {
        return "/" + type.getName().replace('.', '/');
    }

    public String getAbsoluteAddress(String contextRoot, String endpointAddress) {
        if (endpointAddress.startsWith("http")) {
            return endpointAddress;
        }
        String effContextRoot = contextRoot == null ? this.cxfServletAlias : contextRoot;
        return this.httpBase + effContextRoot + endpointAddress;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    @Reference
    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    private final class UnregisterListener
    implements ServiceListener {
        private UnregisterListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() != 4) {
                return;
            }
            ServiceReference sref = event.getServiceReference();
            Long sid = (Long)sref.getProperty("service.id");
            String alias = (String)HttpServiceManager.this.exportedAliases.remove(sid);
            if (alias == null) {
                LOG.error("Unable to unexport HTTP servlet for service class '{}', service-id {}: no servlet alias found", sref.getProperty("objectClass"), (Object)sid);
                return;
            }
            LOG.debug("Unexporting HTTP servlet for alias '{}'", (Object)alias);
            try {
                HttpServiceManager.this.httpService.unregister(alias);
            }
            catch (Exception e) {
                LOG.warn("An exception occurred while unregistering service for HTTP servlet alias '{}'", (Object)alias, (Object)e);
            }
        }
    }
}

