/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.validator.WSDLValidator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="wsdlvalidator", threadSafe=true)
public class WSDLValidatorMojo
extends AbstractMojo {
    @Parameter
    private Boolean verbose;
    @Parameter
    private Boolean quiet;
    @Parameter(property="cxf.wsdlRoot", defaultValue="${basedir}/src/main/resources/wsdl")
    private File wsdlRoot;
    @Parameter(property="cxf.testWsdlRoot", defaultValue="${basedir}/src/test/resources/wsdl")
    private File testWsdlRoot;
    @Parameter(property="cxf.markerDirectory", defaultValue="${project.build.directory}/cxf-wsdl-validator-markers")
    private File markerDirectory;
    @Parameter
    private String[] includes = new String[]{"*.wsdl"};
    @Parameter
    private String[] excludes;

    private static String getIncludeExcludeString(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", arr);
    }

    private List<File> getWsdlFiles(File dir) throws MojoExecutionException {
        ArrayList exList = new ArrayList();
        if (this.excludes != null) {
            Collections.addAll(exList, this.excludes);
        }
        Collections.addAll(exList, FileUtils.getDefaultExcludes());
        String inc = WSDLValidatorMojo.getIncludeExcludeString(this.includes);
        String ex = WSDLValidatorMojo.getIncludeExcludeString(exList.toArray(new String[0]));
        try {
            return FileUtils.getFiles((File)dir, (String)inc, (String)ex);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    private void processWsdl(File file) throws MojoExecutionException {
        File doneFile = new File(this.markerDirectory, "." + file.getName().replace('?', '_').replace('&', '_') + ".DONE");
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (file.lastModified() > doneFile.lastModified()) {
            doWork = true;
        }
        if (doWork) {
            boolean ok;
            doneFile.delete();
            ArrayList<String> list = new ArrayList<String>();
            if (this.verbose != null && this.verbose.booleanValue()) {
                list.add("-verbose");
            }
            if (this.quiet != null && this.quiet.booleanValue()) {
                list.add("-quiet");
            }
            this.getLog().debug((CharSequence)("Calling wsdlvalidator with args: " + String.valueOf(list)));
            try (InputStream toolspecStream = WSDLValidator.class.getResourceAsStream("wsdlvalidator.xml");){
                list.add(file.getCanonicalPath());
                WSDLValidator validator = new WSDLValidator(new ToolSpec(toolspecStream, false));
                validator.setArguments(list.toArray(new String[0]));
                ok = validator.executeForMaven();
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                throw new MojoExecutionException(file.getName() + ": " + e.getMessage(), e);
            }
            if (!ok) {
                throw new MojoExecutionException("WSDL failed validation: " + file.getName());
            }
        }
    }

    public void execute() throws MojoExecutionException {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        this.markerDirectory.mkdirs();
        ArrayList<File> wsdls = new ArrayList<File>();
        if (this.wsdlRoot != null && this.wsdlRoot.exists()) {
            wsdls.addAll(this.getWsdlFiles(this.wsdlRoot));
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists()) {
            wsdls.addAll(this.getWsdlFiles(this.testWsdlRoot));
        }
        for (File wsdl : wsdls) {
            this.processWsdl(wsdl);
        }
    }
}

