/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.maven_plugin.common.DocumentArtifact;
import org.apache.cxf.maven_plugin.wadlto.Option;

public class WadlOption
extends Option {
    String wadl;
    String wadlFileExtension = "wadl";
    DocumentArtifact wadlArtifact;

    public String getWadl() {
        return this.wadl;
    }

    public void setWadl(String w) {
        this.wadl = w;
    }

    public DocumentArtifact getWadlArtifact() {
        return this.wadlArtifact;
    }

    public void setWadlArtifact(DocumentArtifact wadlArtifact) {
        this.wadlArtifact = wadlArtifact;
    }

    public File getDocumentFile(File baseDir) {
        if (this.wadl == null) {
            return null;
        }
        File file = null;
        try {
            URI uri = new URI(this.wadl);
            if (uri.isAbsolute()) {
                file = new File(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            file = new File(this.wadl);
        }
        if (!file.exists()) {
            file = new File(baseDir, this.wadl);
        }
        return file;
    }

    public List<URI> getWadlURIs(URI baseURI, ClassLoader resourceLoader) {
        String wadlLocation = this.getWadl();
        if (wadlLocation.contains(".") && !wadlLocation.contains("*")) {
            return Collections.singletonList(this.getWadlURI(baseURI, wadlLocation));
        }
        LinkedList<URI> uris = new LinkedList<URI>();
        try {
            for (URL nextLocation : ClasspathScanner.findResources((String)wadlLocation, (String)this.wadlFileExtension, (ClassLoader)resourceLoader)) {
                uris.add(this.getWadlURI(baseURI, nextLocation.toURI().getPath()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uris;
    }

    private URI getWadlURI(URI baseURI, String wadlLocation) {
        File wadlFile = new File(wadlLocation);
        return wadlFile.exists() ? wadlFile.toURI() : baseURI.resolve(URIParserUtil.escapeChars((String)wadlLocation));
    }

    public int hashCode() {
        if (this.wadl != null) {
            return this.wadl.hashCode();
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WadlOption)) {
            return false;
        }
        WadlOption t = (WadlOption)obj;
        return t.getWadl().equals(this.getWadl());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("WADL: ").append(this.wadl).append('\n');
        builder.append("OutputDir: ").append(this.outputDir).append('\n');
        builder.append('\n');
        return builder.toString();
    }

    public List<String> generateCommandLine(File outputDirFile, URI basedir, URI wadlURI, boolean debug) {
        ArrayList<String> list = new ArrayList<String>();
        WadlOption.addIfNotNull(list, outputDirFile, "-d");
        for (String binding : this.getBindingFiles()) {
            File bindingFile = new File(binding);
            URI bindingURI = bindingFile.exists() ? bindingFile.toURI() : basedir.resolve(binding);
            list.add("-b");
            list.add(bindingURI.toString());
        }
        WadlOption.addIfNotNull(list, this.getCatalog(), "-catalog");
        WadlOption.addIfNotNull(list, this.getResourcename(), "-resource");
        WadlOption.addIfNotNull(list, this.getPackagename(), "-p");
        WadlOption.addList(list, "-sp", true, this.getSchemaPackagenames());
        WadlOption.addIfTrue(list, this.isImpl(), "-impl");
        WadlOption.addIfTrue(list, this.isInterface(), "-interface");
        WadlOption.addIfNotNull(list, this.getRx(), "-rx");
        WadlOption.addList(list, "", false, this.getExtraargs());
        list.add(wadlURI.toString());
        return list;
    }

    private static void addIfNotNull(List<String> list, Object value, String key) {
        if (value != null) {
            list.add(key);
            list.add(value.toString());
        }
    }

    private static void addList(List<String> destList, String key, boolean keyAsOwnElement, List<String> sourceList) {
        if (sourceList == null) {
            return;
        }
        for (String value : sourceList) {
            if (keyAsOwnElement) {
                destList.add(key);
                destList.add(value);
                continue;
            }
            destList.add(key + (value == null ? "" : value));
        }
    }

    private static void addIfTrue(List<String> list, boolean expression, String key) {
        if (expression) {
            list.add(key);
        }
    }

    public String getWadlFileExtension() {
        return this.wadlFileExtension;
    }

    public void setWadlFileExtension(String wadlFileExtension) {
        this.wadlFileExtension = wadlFileExtension;
    }
}

