/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.wsdl.WSDLManager;

public class EmbeddedJMSBrokerLauncher
extends AbstractBusTestServerBase {
    public static final String PORT = EmbeddedJMSBrokerLauncher.allocatePort(EmbeddedJMSBrokerLauncher.class);
    String brokerUrl1;
    BrokerService broker;
    String brokerName;

    public EmbeddedJMSBrokerLauncher() {
        this(null);
    }

    public EmbeddedJMSBrokerLauncher(String url) {
        if (url == null) {
            url = "tcp://localhost:" + PORT;
        }
        this.brokerUrl1 = url;
    }

    public void setBrokerName(String s) {
        this.brokerName = s;
    }

    public String getBrokerURL() {
        return this.brokerUrl1;
    }

    public String getEncodedBrokerURL() {
        StringBuilder b = new StringBuilder(this.brokerUrl1.length());
        block3: for (int x = 0; x < this.brokerUrl1.length(); ++x) {
            char c = this.brokerUrl1.charAt(x);
            switch (c) {
                case '?': {
                    b.append("%3F");
                    continue block3;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public void updateWsdl(Bus b, URL wsdlLocation) {
        this.updateWsdl(b, wsdlLocation.toString());
    }

    public void updateWsdl(Bus b, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(b, wsdlLocation, this.brokerUrl1, this.getEncodedBrokerURL());
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(bus, wsdlLocation, "tcp://localhost:" + PORT, null);
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation, String url, String encodedUrl) {
        try {
            if (encodedUrl == null) {
                encodedUrl = url;
            }
            if (bus == null) {
                bus = BusFactory.getThreadDefaultBus();
            }
            Definition def = ((WSDLManager)bus.getExtension(WSDLManager.class)).getDefinition(wsdlLocation);
            Map map = def.getAllServices();
            for (Object o : map.values()) {
                Service service = (Service)o;
                Map ports = service.getPorts();
                EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(service.getExtensibilityElements(), url, encodedUrl);
                for (Object p : ports.values()) {
                    Port port = (Port)p;
                    EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(port.getExtensibilityElements(), url, encodedUrl);
                    EmbeddedJMSBrokerLauncher.adjustExtensibilityElements(port.getBinding().getExtensibilityElements(), url, encodedUrl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void adjustExtensibilityElements(List<?> l, String url, String encodedUrl) {
        for (Object e : l) {
            if (e instanceof SOAPAddress) {
                String add = ((SOAPAddress)e).getLocationURI();
                int idx = add.indexOf("jndiURL=");
                if (idx == -1) continue;
                int idx2 = add.indexOf("&", idx);
                add = add.substring(0, idx) + "jndiURL=" + encodedUrl + (idx2 == -1 ? "" : add.substring(idx2));
                ((SOAPAddress)e).setLocationURI(add);
                continue;
            }
            if (e.getClass().getSimpleName().startsWith("JndiURLType")) {
                try {
                    e.getClass().getMethod("setValue", String.class).invoke(e, url);
                }
                catch (Exception add) {}
                continue;
            }
            try {
                Field f = e.getClass().getDeclaredField("jmsNamingProperty");
                ReflectionUtil.setAccessible((AccessibleObject)f);
                List props = (List)f.get(e);
                for (Object prop : props) {
                    f = prop.getClass().getDeclaredField("name");
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    if (!"java.naming.provider.url".equals(f.get(prop))) continue;
                    f = prop.getClass().getDeclaredField("value");
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    String value = (String)f.get(prop);
                    if (value != null && value.startsWith("classpath")) continue;
                    f.set(prop, url);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void stop() throws Exception {
        this.tearDown();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Override
    public final void run() {
        try {
            this.broker = new BrokerService();
            this.broker.setPersistent(false);
            this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
            this.broker.setTmpDataDirectory(new File("./target"));
            this.broker.setUseJmx(false);
            if (this.brokerName != null) {
                this.broker.setBrokerName(this.brokerName);
            }
            this.broker.addConnector(this.brokerUrl1);
            this.broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String url = null;
            if (args.length > 0) {
                url = args[0];
            }
            EmbeddedJMSBrokerLauncher s = new EmbeddedJMSBrokerLauncher(url);
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

