/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.customer.bare;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.customer.Customer;
import org.apache.cxf.customer.CustomerNotFoundDetails;
import org.apache.cxf.customer.CustomerNotFoundFault;
import org.apache.cxf.customer.Customers;
import org.apache.cxf.customer.bare.GetCustomer;
import org.apache.cxf.customer.bare.GetCustomers;
import org.codehaus.jra.Delete;
import org.codehaus.jra.Get;
import org.codehaus.jra.HttpResource;
import org.codehaus.jra.Post;
import org.codehaus.jra.Put;

@WebService(targetNamespace="http://cxf.apache.org/jra")
public class CustomerService {
    long currentId = 1L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();
    @Resource
    private WebServiceContext context;

    public CustomerService() {
        Customer customer = this.createCustomer();
        this.customers.put(customer.getId(), customer);
    }

    @Get
    @HttpResource(location="/customers")
    @WebMethod
    @WebResult(name="customers")
    public Customers getCustomers(@WebParam(name="GetCustomers") GetCustomers req) {
        Customers cbean = new Customers();
        cbean.setCustomer(this.customers.values());
        if (this.context == null || this.context.getMessageContext() == null) {
            throw new WebServiceException("WebServiceContext is null!");
        }
        return cbean;
    }

    @Get
    @HttpResource(location="/customers/{id}")
    @WebMethod
    @WebResult(name="customer")
    public Customer getCustomer(@WebParam(name="getCustomer") GetCustomer getCustomer) throws CustomerNotFoundFault {
        Customer c = this.customers.get(getCustomer.getId());
        if (c == null) {
            CustomerNotFoundDetails details = new CustomerNotFoundDetails();
            details.setId(getCustomer.getId());
            throw new CustomerNotFoundFault(details);
        }
        return c;
    }

    @Get
    @HttpResource(location="/customers/details/{id}")
    @WebMethod
    public String getSomeDetails(@WebParam(name="getSomeDetails") GetCustomer getCustomer) throws CustomerNotFoundFault {
        return "some details";
    }

    @Put
    @HttpResource(location="/customers/{id}")
    @WebMethod
    public void updateCustomer(@WebParam(name="customer") Customer c) {
        this.customers.put(c.getId(), c);
    }

    @Post
    @HttpResource(location="/customers")
    @WebMethod
    public void addCustomer(@WebParam(name="customer") Customer c) {
        long id = ++this.currentId;
        c.setId(id);
        this.customers.put(id, c);
    }

    @Delete
    @HttpResource(location="/customers/{id}")
    @WebMethod
    public void deleteCustomer(long id) {
        this.customers.remove(id);
    }

    final Customer createCustomer() {
        Customer c = new Customer();
        c.setName("Dan Diephouse");
        c.setId(123L);
        return c;
    }
}

