/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.List;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.micrometer.MicrometerMetricsProperties;
import org.apache.cxf.metrics.micrometer.MicrometerMetricsProvider;
import org.apache.cxf.metrics.micrometer.provider.DefaultExceptionClassProvider;
import org.apache.cxf.metrics.micrometer.provider.ExceptionClassProvider;
import org.apache.cxf.metrics.micrometer.provider.StandardTags;
import org.apache.cxf.metrics.micrometer.provider.StandardTagsProvider;
import org.apache.cxf.metrics.micrometer.provider.TagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.TagsProvider;
import org.apache.cxf.metrics.micrometer.provider.TimedAnnotationProvider;
import org.apache.cxf.metrics.micrometer.provider.jaxrs.JaxrsOperationTagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.jaxrs.JaxrsTags;
import org.apache.cxf.metrics.micrometer.provider.jaxws.JaxwsFaultCodeProvider;
import org.apache.cxf.metrics.micrometer.provider.jaxws.JaxwsFaultCodeTagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.jaxws.JaxwsOperationTagsCustomizer;
import org.apache.cxf.metrics.micrometer.provider.jaxws.JaxwsTags;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.spring.boot.autoconfigure.micrometer.provider.SpringBasedTimedAnnotationProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.micrometer.metrics.MaximumAllowableTagsMeterFilter;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={MetricsProvider.class})
@ConditionalOnProperty(name={"cxf.metrics.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={MeterRegistry.class})
public class MicrometerMetricsAutoConfiguration {
    private final CxfProperties properties;

    public MicrometerMetricsAutoConfiguration(CxfProperties properties) {
        this.properties = properties;
    }

    @Bean
    public TimedAnnotationProvider timedAnnotationProvider() {
        return new SpringBasedTimedAnnotationProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionClassProvider.class})
    public ExceptionClassProvider exceptionClassProvider() {
        return new DefaultExceptionClassProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={StandardTags.class})
    public StandardTags standardTags() {
        return new StandardTags();
    }

    @Bean
    @ConditionalOnMissingBean(value={TagsProvider.class})
    public TagsProvider tagsProvider(ExceptionClassProvider exceptionClassProvider, StandardTags standardTags) {
        return new StandardTagsProvider(exceptionClassProvider, standardTags);
    }

    @Bean
    @ConditionalOnMissingBean(value={MetricsProvider.class})
    public MetricsProvider metricsProvider(TagsProvider tagsProvider, List<TagsCustomizer> tagsCustomizers, TimedAnnotationProvider timedAnnotationProvider, MeterRegistry registry) {
        MicrometerMetricsProperties micrometerMetricsProperties = new MicrometerMetricsProperties();
        CxfProperties.Metrics.Server server = this.properties.getMetrics().getServer();
        micrometerMetricsProperties.setAutoTimeRequests(server.isAutoTimeRequests());
        micrometerMetricsProperties.setServerRequestsMetricName(server.getRequestsMetricName());
        CxfProperties.Metrics.Client client = this.properties.getMetrics().getClient();
        micrometerMetricsProperties.setClientRequestsMetricName(client.getRequestsMetricName());
        return new MicrometerMetricsProvider(registry, tagsProvider, tagsCustomizers, timedAnnotationProvider, micrometerMetricsProperties);
    }

    @Bean
    @Order(value=0)
    public MeterFilter cxfMetricsMaxAllowedServerUriTagsFilter() {
        String metricName = this.properties.getMetrics().getServer().getRequestsMetricName();
        return new MaximumAllowableTagsMeterFilter(metricName, "uri", this.properties.getMetrics().getServer().getMaxUriTags());
    }

    @Bean
    @Order(value=0)
    public MeterFilter cxfMetricsMaxAllowedClientUriTagsFilter() {
        String metricName = this.properties.getMetrics().getClient().getRequestsMetricName();
        return new MaximumAllowableTagsMeterFilter(metricName, "uri", this.properties.getMetrics().getClient().getMaxUriTags());
    }

    @Configuration
    @ConditionalOnClass(value={JAXRSServerFactoryBean.class})
    @ConditionalOnProperty(name={"cxf.metrics.jaxrs.enabled"}, matchIfMissing=true)
    protected static class JaxRsMetricsConfiguration {
        protected JaxRsMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxrsTags.class})
        public JaxrsTags jaxrsTags() {
            return new JaxrsTags();
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxrsOperationTagsCustomizer.class})
        public JaxrsOperationTagsCustomizer jaxrsOperationTagsCustomizer(JaxrsTags jaxrsTags) {
            return new JaxrsOperationTagsCustomizer(jaxrsTags);
        }
    }

    @Configuration
    @ConditionalOnClass(value={JaxWsServerFactoryBean.class})
    @ConditionalOnProperty(name={"cxf.metrics.jaxws.enabled"}, matchIfMissing=true)
    protected static class JaxWsMetricsConfiguration {
        protected JaxWsMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxwsFaultCodeProvider.class})
        public JaxwsFaultCodeProvider jaxwsFaultCodeProvider() {
            return new JaxwsFaultCodeProvider();
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxwsFaultCodeTagsCustomizer.class})
        public JaxwsFaultCodeTagsCustomizer jaxwsFaultCodeTagsCustomizer(JaxwsTags jaxwsTags, JaxwsFaultCodeProvider jaxwsFaultCodeProvider) {
            return new JaxwsFaultCodeTagsCustomizer(jaxwsTags, jaxwsFaultCodeProvider);
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxwsOperationTagsCustomizer.class})
        public JaxwsOperationTagsCustomizer jaxwsOperationTagsCustomizer(JaxwsTags jaxwsTags) {
            return new JaxwsOperationTagsCustomizer(jaxwsTags);
        }

        @Bean
        @ConditionalOnMissingBean(value={JaxwsTags.class})
        public JaxwsTags jaxwsTags() {
            return new JaxwsTags();
        }
    }
}

