/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="cxf")
@Validated
public class CxfProperties {
    private String path = "/services";
    private final Servlet servlet = new Servlet();
    private final Metrics metrics = new Metrics();

    @NotNull
    @Pattern(regexp="/[^?#]*", message="Path must start with /")
    public @NotNull @Pattern(regexp="/[^?#]*", message="Path must start with /") String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public static class Metrics {
        private final Server server = new Server();
        private boolean enabled = true;

        public Server getServer() {
            return this.server;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public static class Server {
            private boolean autoTimeRequests = true;
            private String requestsMetricName = "cxf.server.requests";
            private int maxUriTags = 100;

            public boolean isAutoTimeRequests() {
                return this.autoTimeRequests;
            }

            public void setAutoTimeRequests(boolean autoTimeRequests) {
                this.autoTimeRequests = autoTimeRequests;
            }

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }
    }

    public static class Servlet {
        private Map<String, String> init = new HashMap<String, String>();
        private int loadOnStartup = -1;

        public Map<String, String> getInit() {
            return this.init;
        }

        public void setInit(Map<String, String> init) {
            this.init = init;
        }

        public int getLoadOnStartup() {
            return this.loadOnStartup;
        }

        public void setLoadOnStartup(int loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
        }
    }
}

