/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSTokenRetriever;

public class STSTokenOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(STSTokenOutInterceptor.class);
    private static final String TOKEN_TYPE_SAML_2_0 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    private static final String KEY_TYPE_X509 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey";
    private static final String WS_TRUST_NS = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    private static final QName STS_SERVICE_NAME = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "SecurityTokenService");
    private static final QName X509_ENDPOINT = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "X509_Port");
    private static final QName TRANSPORT_ENDPOINT = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "Transport_Port");
    private STSClient stsClient;
    private STSTokenRetriever.TokenRequestParams tokenParams;

    public STSTokenOutInterceptor(AuthParams authParams, String stsWsdlLocation, Bus bus) {
        this("prepare-send", authParams, stsWsdlLocation, bus);
    }

    public STSTokenOutInterceptor(String phase, AuthParams authParams, String stsWsdlLocation, Bus bus) {
        super(phase);
        this.stsClient = this.configureBasicSTSClient(authParams, stsWsdlLocation, bus);
        this.tokenParams = new STSTokenRetriever.TokenRequestParams();
    }

    public STSTokenOutInterceptor(STSClient stsClient) {
        this("prepare-send", stsClient, new STSTokenRetriever.TokenRequestParams());
    }

    public STSTokenOutInterceptor(STSClient stsClient, STSTokenRetriever.TokenRequestParams tokenParams) {
        this("prepare-send", stsClient, tokenParams);
    }

    public STSTokenOutInterceptor(String phase, STSClient stsClient, STSTokenRetriever.TokenRequestParams tokenParams) {
        super(phase);
        this.stsClient = stsClient;
        this.tokenParams = tokenParams;
    }

    public void handleMessage(Message message) throws Fault {
        SecurityToken tok;
        if (this.stsClient != null) {
            message.put((Object)"security.sts.client", (Object)this.stsClient);
        }
        if ((tok = STSTokenRetriever.getToken(message, this.tokenParams)) == null) {
            LOG.warning("Security token was not retrieved from STS");
        }
        this.processToken(message, tok);
    }

    protected void processToken(Message message, SecurityToken tok) {
    }

    public STSClient getSTSClient() {
        return this.stsClient;
    }

    private STSClient configureBasicSTSClient(AuthParams authParams, String stsWsdlLocation, Bus bus) {
        STSClient basicStsClient = new STSClient(bus);
        basicStsClient.setWsdlLocation(stsWsdlLocation);
        basicStsClient.setServiceName(STS_SERVICE_NAME.toString());
        basicStsClient.setEndpointName(authParams.getAuthMode().endpointName.toString());
        if (authParams.getAuthMode().getKeyType() != null) {
            basicStsClient.setKeyType(authParams.getAuthMode().getKeyType());
        } else {
            basicStsClient.setSendKeyType(false);
        }
        basicStsClient.setTokenType(TOKEN_TYPE_SAML_2_0);
        basicStsClient.setAllowRenewingAfterExpiry(true);
        basicStsClient.setEnableLifetime(true);
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (authParams.getUserName() != null) {
            props.put("security.username", authParams.getUserName());
        }
        props.put("security.callback-handler", authParams.getCallbackHandler());
        if (authParams.getKeystoreProperties() != null && authParams.getKeystoreProperties() != null) {
            props.put("security.encryption.username", authParams.getAlias());
            props.put("security.encryption.properties", authParams.getKeystoreProperties());
            props.put("security.signature.properties", authParams.getKeystoreProperties());
            props.put("security.sts.token.username", authParams.getAlias());
            props.put("security.sts.token.properties", authParams.getKeystoreProperties());
            props.put("security.sts.token.usecert", "true");
        }
        basicStsClient.setProperties(props);
        return basicStsClient;
    }

    static /* synthetic */ QName access$000() {
        return X509_ENDPOINT;
    }

    static /* synthetic */ QName access$100() {
        return TRANSPORT_ENDPOINT;
    }

    public static class AuthParams {
        private final AuthMode authMode;
        private final String userName;
        private final String callbackHandler;
        private final String alias;
        private final String keystoreProperties;

        public AuthParams(AuthMode authMode, String userName, String callbackHandler) {
            this(authMode, userName, callbackHandler, null, null);
        }

        public AuthParams(AuthMode authMode, String userName, String callbackHandler, String alias, String keystoreProperties) {
            this.authMode = authMode;
            this.userName = userName;
            this.callbackHandler = callbackHandler;
            this.alias = alias;
            this.keystoreProperties = keystoreProperties;
        }

        public AuthMode getAuthMode() {
            return this.authMode;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getCallbackHandler() {
            return this.callbackHandler;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getKeystoreProperties() {
            return this.keystoreProperties;
        }
    }

    public static enum AuthMode {
        X509(STSTokenOutInterceptor.access$000(), "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey"),
        TRANSPORT(STSTokenOutInterceptor.access$100(), null);

        private final QName endpointName;
        private final String keyType;

        private AuthMode(QName endpointName, String keyType) {
            this.endpointName = endpointName;
            this.keyType = keyType;
        }

        public QName getEndpointName() {
            return this.endpointName;
        }

        public String getKeyType() {
            return this.keyType;
        }
    }
}

