/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractToken;

public abstract class AbstractSamlPolicyValidator
extends AbstractTokenPolicyValidator {
    @Override
    protected boolean isTokenRequired(AbstractToken token, Message message) {
        SPConstants.IncludeTokenType inclusion = token.getIncludeTokenType();
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            return false;
        }
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS) {
            return true;
        }
        boolean initiator = MessageUtils.isRequestor((Message)message);
        if (initiator && inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR) {
            return true;
        }
        return !initiator && (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT);
    }

    public boolean checkHolderOfKey(SamlAssertionWrapper assertionWrapper, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        return DOMSAMLUtil.checkHolderOfKey((SamlAssertionWrapper)assertionWrapper, signedResults, (Certificate[])tlsCerts);
    }

    protected boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        return DOMSAMLUtil.compareCredentials((SAMLKeyInfo)subjectKeyInfo, signedResults, (Certificate[])tlsCerts);
    }
}

