/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.neethi.Assertion;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.AsymmetricBinding;
import org.apache.wss4j.policy.model.X509Token;
import org.w3c.dom.Element;

public class AsymmetricBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, soapBody, results, signedResults, encryptedResults);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean hasDerivedKeys = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2048) continue;
            hasDerivedKeys = true;
            break;
        }
        for (AssertionInfo ai : ais) {
            AsymmetricBinding binding = (AsymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (this.checkProtectionOrder((AbstractSymmetricAsymmetricBinding)binding, aim, ai, results) && this.checkProperties((AbstractSymmetricAsymmetricBinding)binding, ai, aim, results, signedResults, message) && this.checkTokens(binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults)) continue;
        }
    }

    private boolean checkTokens(AsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean result = true;
        if (binding.getInitiatorToken() != null) {
            result &= this.checkInitiatorTokens((AbstractTokenWrapper)binding.getInitiatorToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        if (binding.getInitiatorSignatureToken() != null) {
            result &= this.checkInitiatorTokens((AbstractTokenWrapper)binding.getInitiatorSignatureToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        if (binding.getInitiatorEncryptionToken() != null) {
            result &= this.checkInitiatorTokens((AbstractTokenWrapper)binding.getInitiatorEncryptionToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        if (binding.getRecipientToken() != null) {
            result &= this.checkRecipientTokens((AbstractTokenWrapper)binding.getRecipientToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        if (binding.getRecipientSignatureToken() != null) {
            result &= this.checkRecipientTokens((AbstractTokenWrapper)binding.getRecipientSignatureToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        if (binding.getRecipientEncryptionToken() != null) {
            result &= this.checkRecipientTokens((AbstractTokenWrapper)binding.getRecipientEncryptionToken(), binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults);
        }
        return result;
    }

    private boolean checkInitiatorTokens(AbstractTokenWrapper wrapper, AsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        AbstractToken token = wrapper.getToken();
        if (token instanceof X509Token) {
            boolean foundCert = false;
            for (WSSecurityEngineResult result : signedResults) {
                X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
                if (cert == null) continue;
                foundCert = true;
                break;
            }
            if (!foundCert && !signedResults.isEmpty()) {
                String error = "An X.509 certificate was not used for the " + wrapper.getName();
                this.notAssertPolicy(aim, wrapper.getName(), error);
                ai.setNotAsserted(error);
                return false;
            }
        }
        this.assertPolicy(aim, (Assertion)wrapper);
        if (!this.checkDerivedKeys(wrapper, hasDerivedKeys, signedResults, encryptedResults)) {
            ai.setNotAsserted("Message fails the DerivedKeys requirement");
            return false;
        }
        this.assertPolicy(aim, "RequireDerivedKeys");
        this.assertPolicy(aim, "RequireImpliedDerivedKeys");
        this.assertPolicy(aim, "RequireExplicitDerivedKeys");
        return true;
    }

    private boolean checkRecipientTokens(AbstractTokenWrapper wrapper, AsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        this.assertPolicy(aim, (Assertion)wrapper);
        if (!this.checkDerivedKeys(wrapper, hasDerivedKeys, signedResults, encryptedResults)) {
            ai.setNotAsserted("Message fails the DerivedKeys requirement");
            return false;
        }
        this.assertPolicy(aim, "RequireDerivedKeys");
        this.assertPolicy(aim, "RequireImpliedDerivedKeys");
        this.assertPolicy(aim, "RequireExplicitDerivedKeys");
        return true;
    }
}

