/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.Closeable;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.wss4j.common.cache.EHCacheManagerHolder;

public class EHCacheTokenStore
implements TokenStore,
Closeable,
BusLifeCycleListener {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private Ehcache cache;
    private Bus bus;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheTokenStore(String key, Bus b, URL configFileURL) {
        this.bus = b;
        if (this.bus != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
        String confName = "";
        if (this.bus != null) {
            confName = this.bus.getId();
        }
        this.cacheManager = EHCacheManagerHolder.getCacheManager((String)confName, (URL)configFileURL);
        CacheConfiguration cc = EHCacheManagerHolder.getCacheConfiguration((String)key, (CacheManager)this.cacheManager).overflowToDisk(false);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
        this.ttl = cc.getTimeToLiveSeconds();
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    @Override
    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            Element element = new Element((Object)token.getId(), (Object)token, this.getTTL(), this.getTTL());
            element.resetAccessStatistics();
            this.cache.put(element);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)identifier)) {
            Element element = new Element((Object)identifier, (Object)token, this.getTTL(), this.getTTL());
            element.resetAccessStatistics();
            this.cache.put(element);
        }
    }

    @Override
    public void remove(String identifier) {
        if (!StringUtils.isEmpty((String)identifier) && this.cache.isKeyInCache((Object)identifier)) {
            this.cache.remove((Serializable)((Object)identifier));
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        return this.cache.getKeysWithExpiryCheck();
    }

    @Override
    public SecurityToken getToken(String identifier) {
        Element element = this.cache.get((Serializable)((Object)identifier));
        if (element != null && !this.cache.isExpired(element)) {
            return (SecurityToken)element.getObjectValue();
        }
        return null;
    }

    private int getTTL() {
        int parsedTTL = (int)this.ttl;
        if (this.ttl != (long)parsedTTL) {
            parsedTTL = 3600;
        }
        return parsedTTL;
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            EHCacheManagerHolder.releaseCacheManger((CacheManager)this.cacheManager);
            this.cacheManager = null;
            this.cache = null;
            if (this.bus != null) {
                ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

