/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.manager;

import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.eventing.DeliveryType;
import org.apache.cxf.ws.eventing.ExpirationType;
import org.apache.cxf.ws.eventing.FilterType;
import org.apache.cxf.ws.eventing.FormatType;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionDatabase;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionDatabaseImpl;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionManager;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionTicketGrantingResponse;
import org.apache.cxf.ws.eventing.backend.notification.NotificatorService;
import org.apache.cxf.ws.eventing.backend.notification.SubscriptionEndStatus;
import org.apache.cxf.ws.eventing.shared.faults.CannotProcessFilter;
import org.apache.cxf.ws.eventing.shared.faults.DeliveryFormatRequestedUnavailable;
import org.apache.cxf.ws.eventing.shared.faults.FilteringRequestedUnavailable;
import org.apache.cxf.ws.eventing.shared.faults.NoDeliveryMechanismEstablished;
import org.apache.cxf.ws.eventing.shared.faults.UnknownSubscription;
import org.apache.cxf.ws.eventing.shared.utils.DurationAndDateUtil;
import org.apache.cxf.ws.eventing.shared.utils.EPRInspectionTool;
import org.apache.cxf.ws.eventing.shared.utils.FilteringUtil;

public class SubscriptionManagerImpl
implements SubscriptionManager {
    protected static final Logger LOG = LogUtils.getLogger(SubscriptionManagerImpl.class);
    protected final SubscriptionDatabase database = new SubscriptionDatabaseImpl();
    private final String subscriptionIdNamespace;
    private final String subscriptionIdElementName;
    private String url;
    private NotificatorService notificator;

    public SubscriptionManagerImpl(String url) {
        this.subscriptionIdNamespace = "http://cxf.apache.org/ws-eventing";
        this.subscriptionIdElementName = "SubscriptionID";
        this.url = url;
    }

    public SubscriptionManagerImpl(String url, String namespace, String elementName) {
        this.url = url;
        this.subscriptionIdNamespace = namespace;
        this.subscriptionIdElementName = elementName;
    }

    @Override
    public SubscriptionTicketGrantingResponse subscribe(DeliveryType delivery, EndpointReferenceType endTo, ExpirationType expires, FilterType filter, FormatType format) {
        SubscriptionTicket ticket = new SubscriptionTicket();
        SubscriptionTicketGrantingResponse response = new SubscriptionTicketGrantingResponse();
        this.grantSubscriptionManagerReference(ticket, response);
        this.processDelivery(delivery, ticket, response);
        this.processEndTo(endTo, ticket, response);
        this.processExpiration(expires, ticket, response);
        this.processFilters(filter, ticket, response);
        this.processFormat(format, ticket, response);
        this.getDatabase().addTicket(ticket);
        return response;
    }

    @Override
    public List<SubscriptionTicket> getTickets() {
        return Collections.unmodifiableList(this.database.getTickets());
    }

    protected SubscriptionDatabase getDatabase() {
        return this.database;
    }

    protected void processFormat(FormatType format, SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        if (format == null) {
            ticket.setWrappedDelivery(false);
            return;
        }
        if (format.getName().equals("http://www.w3.org/2011/03/ws-evt/DeliveryFormats/Wrap")) {
            LOG.info("[subscription=" + ticket.getUuid() + "] Wrapped delivery format was requested.");
            ticket.setWrappedDelivery(true);
        } else if (format.getName().equals("http://www.w3.org/2011/03/ws-evt/DeliveryFormats/Unwrap")) {
            LOG.info("[subscription=" + ticket.getUuid() + "] Wrapped delivery format was NOT requested.");
            ticket.setWrappedDelivery(false);
        } else {
            LOG.info("[subscription=" + ticket.getUuid() + "] Unknown delivery format: " + format.getName());
            throw new DeliveryFormatRequestedUnavailable();
        }
    }

    protected void processFilters(FilterType request, SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        if (request != null) {
            if (FilteringUtil.isFilteringDialectSupported(request.getDialect())) {
                String filter = (String)request.getContent().get(0);
                LOG.fine("Found filter content: " + filter);
                if (!FilteringUtil.isValidFilter(filter)) {
                    throw new CannotProcessFilter();
                }
                ticket.setFilter(request);
            } else {
                throw new FilteringRequestedUnavailable();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processExpiration(ExpirationType request, SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        XMLGregorianCalendar granted;
        if (request != null) {
            Object expirationTypeValue;
            try {
                expirationTypeValue = DurationAndDateUtil.parseDurationOrTimestamp(request.getValue());
            }
            catch (IllegalArgumentException ex) {
                throw new SoapFault("Cannot parse expiration", new QName("http://cxf.apache.org/eventing", "Error"));
            }
            Boolean bestEffort = request.isBestEffort();
            if (bestEffort != null && bestEffort.booleanValue()) {
                if (expirationTypeValue instanceof Duration) {
                    granted = this.grantExpirationFor((Duration)expirationTypeValue);
                } else {
                    if (!(expirationTypeValue instanceof XMLGregorianCalendar)) throw new Error("expirationTypeValue of unexpected type: " + expirationTypeValue.getClass());
                    granted = this.grantExpirationFor((XMLGregorianCalendar)expirationTypeValue);
                }
            } else if (expirationTypeValue instanceof Duration) {
                try {
                    if (DurationAndDateUtil.isPT0S((Duration)expirationTypeValue)) {
                        ticket.setNonExpiring(true);
                    }
                    granted = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                    granted.add((Duration)expirationTypeValue);
                }
                catch (DatatypeConfigurationException e) {
                    throw new Error(e);
                }
            } else {
                if (!(expirationTypeValue instanceof XMLGregorianCalendar)) throw new Error("expirationTypeValue of unexpected type: " + expirationTypeValue.getClass());
                granted = (XMLGregorianCalendar)expirationTypeValue;
            }
        } else {
            granted = this.grantExpiration();
        }
        ticket.setExpires(granted);
        response.setExpires(granted);
        LOG.info("[subscription=" + ticket.getUuid() + "] Granted Expiration date: " + granted.toString());
    }

    protected void processEndTo(EndpointReferenceType request, SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        if (request != null) {
            ticket.setEndTo(request);
        }
    }

    protected void processDelivery(DeliveryType request, SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        try {
            JAXBElement notifyTo = (JAXBElement)request.getContent().get(0);
            if (!EPRInspectionTool.containsUsableEPR((EndpointReferenceType)notifyTo.getValue())) {
                throw new NoDeliveryMechanismEstablished();
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException npe) {
            throw new NoDeliveryMechanismEstablished();
        }
        ticket.setDelivery(request);
    }

    protected void grantSubscriptionManagerReference(SubscriptionTicket ticket, SubscriptionTicketGrantingResponse response) {
        EndpointReferenceType subscriptionManagerReference = new EndpointReferenceType();
        subscriptionManagerReference.setAddress(this.getSubscriptionManagerAddress());
        UUID uuid = UUID.randomUUID();
        JAXBElement idqn = new JAXBElement(new QName(this.subscriptionIdNamespace, this.subscriptionIdElementName), String.class, (Object)uuid.toString());
        subscriptionManagerReference.setReferenceParameters(new ReferenceParametersType());
        subscriptionManagerReference.getReferenceParameters().getAny().add(idqn);
        ticket.setUuid(uuid);
        response.setSubscriptionManagerReference(subscriptionManagerReference);
        response.setUUID(uuid);
    }

    public XMLGregorianCalendar grantExpirationFor(XMLGregorianCalendar requested) {
        return requested;
    }

    public XMLGregorianCalendar grantExpirationFor(Duration requested) {
        try {
            XMLGregorianCalendar granted = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            if (DurationAndDateUtil.isPT0S(requested)) {
                granted.add(DatatypeFactory.newInstance().newDurationYearMonth(true, 5, 0));
            } else {
                granted.add(requested);
            }
            return granted;
        }
        catch (DatatypeConfigurationException e) {
            throw new Error(e);
        }
    }

    public XMLGregorianCalendar grantExpiration() {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar granted = factory.newXMLGregorianCalendar(new GregorianCalendar());
            granted.add(factory.newDurationYearMonth(true, 2, 0));
            return granted;
        }
        catch (DatatypeConfigurationException ex) {
            throw new Error(ex);
        }
    }

    public AttributedURIType getSubscriptionManagerAddress() {
        AttributedURIType ret = new AttributedURIType();
        ret.setValue(this.url);
        return ret;
    }

    @Override
    public void unsubscribeTicket(UUID uuid) {
        this.getDatabase().removeTicketByUUID(uuid);
    }

    @Override
    public SubscriptionTicket findTicket(UUID uuid) {
        return this.getDatabase().findById(uuid);
    }

    @Override
    public ExpirationType renew(UUID uuid, ExpirationType requestedExpiration) {
        XMLGregorianCalendar grantedExpires;
        SubscriptionTicket ticket = this.getDatabase().findById(uuid);
        if (ticket == null) {
            throw new UnknownSubscription();
        }
        LOG.info("[subscription=" + ticket.getUuid() + "] Requested renew expiration: " + requestedExpiration.getValue());
        LOG.fine("[subscription=" + ticket.getUuid() + "] Current expiration: " + ticket.getExpires().toXMLFormat());
        ExpirationType response = new ExpirationType();
        if (DurationAndDateUtil.isDuration(requestedExpiration.getValue())) {
            Duration requestedDuration;
            Duration grantedDuration = requestedDuration = DurationAndDateUtil.parseDuration(requestedExpiration.getValue());
            LOG.info("[subscription=" + ticket.getUuid() + "] Granted renewal duration: " + grantedDuration.toString());
            grantedExpires = this.getDatabase().findById(uuid).getExpires();
            grantedExpires.add(grantedDuration);
            response.setValue(grantedDuration.toString());
        } else {
            grantedExpires = DurationAndDateUtil.parseXMLGregorianCalendar(requestedExpiration.getValue());
            LOG.info("[subscription=" + ticket.getUuid() + "] Granted expiration: " + grantedExpires.toXMLFormat());
            response.setValue(grantedExpires.toXMLFormat());
        }
        this.getDatabase().findById(uuid).setExpires(grantedExpires);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscriptionEnd(UUID subscriptionId, String reason, SubscriptionEndStatus status) {
        SubscriptionDatabase subscriptionDatabase = this.database;
        synchronized (subscriptionDatabase) {
            SubscriptionTicket ticket = this.database.findById(subscriptionId);
            if (ticket != null) {
                this.database.removeTicketByUUID(subscriptionId);
                if (ticket.getEndToURL() != null) {
                    this.notificator.subscriptionEnd(ticket, reason, status);
                }
            } else {
                LOG.severe("No such subscription: " + subscriptionId);
            }
        }
    }

    @Override
    public void registerNotificator(NotificatorService service) {
        this.notificator = service;
    }
}

