/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorContextImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.RSSecurityUtils;
import org.apache.cxf.rs.security.common.TrustValidator;
import org.apache.cxf.rs.security.xml.EncryptionProperties;
import org.apache.cxf.rs.security.xml.SignatureProperties;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InboundXMLSec;
import org.apache.xml.security.stax.ext.XMLSec;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.impl.securityToken.KeyNameSecurityToken;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class XmlSecInInterceptor
extends AbstractPhaseInterceptor<Message>
implements ReaderInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSecInInterceptor.class);
    private EncryptionProperties encryptionProperties;
    private SignatureProperties sigProps;
    private String decryptionAlias;
    private String signatureVerificationAlias;
    private boolean persistSignature = true;
    private boolean requireSignature;
    private boolean requireEncryption;
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public XmlSecInInterceptor() {
        super("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.canDocumentBeRead(message)) {
            return;
        }
        this.prepareMessage(message);
        message.getInterceptorChain().add((Interceptor)new StaxActionInInterceptor(this.requireSignature, this.requireEncryption));
    }

    private void prepareMessage(Message inMsg) throws Fault {
        InputStream is;
        XMLStreamReader originalXmlStreamReader = (XMLStreamReader)inMsg.getContent(XMLStreamReader.class);
        if (originalXmlStreamReader == null && (is = (InputStream)inMsg.getContent(InputStream.class)) != null) {
            originalXmlStreamReader = StaxUtils.createXMLStreamReader((InputStream)is);
        }
        try {
            XMLSecurityProperties properties = new XMLSecurityProperties();
            this.configureDecryptionKeys(inMsg, properties);
            Crypto signatureCrypto = this.getSignatureCrypto(inMsg);
            this.configureSignatureKeys(signatureCrypto, inMsg, properties);
            SecurityEventListener securityEventListener = this.configureSecurityEventListener(signatureCrypto, inMsg, properties);
            InboundXMLSec inboundXMLSec = XMLSec.getInboundWSSec((XMLSecurityProperties)properties);
            XMLStreamReader newXmlStreamReader = inboundXMLSec.processInMessage(originalXmlStreamReader, null, securityEventListener);
            inMsg.setContent(XMLStreamReader.class, (Object)newXmlStreamReader);
        }
        catch (IOException | UnsupportedCallbackException | XMLStreamException | XMLSecurityException e) {
            this.throwFault(e.getMessage(), (Exception)e);
        }
    }

    private boolean canDocumentBeRead(Message message) {
        if (this.isServerGet(message)) {
            return false;
        }
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        return responseCode == null || responseCode == 200;
    }

    private boolean isServerGet(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        return "GET".equals(method) && !MessageUtils.isRequestor((Message)message);
    }

    private void configureDecryptionKeys(Message message, XMLSecurityProperties properties) throws IOException, UnsupportedCallbackException, WSSecurityException {
        String cryptoKey = null;
        String propKey = null;
        if (RSSecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "security.signature.crypto";
            propKey = "security.signature.properties";
        } else {
            cryptoKey = "security.encryption.crypto";
            propKey = "security.encryption.properties";
        }
        Crypto crypto = null;
        try {
            crypto = new CryptoLoader().getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
        }
        if (crypto != null) {
            String alias = this.decryptionAlias;
            if (alias == null) {
                alias = crypto.getDefaultX509Identifier();
            }
            if (alias != null) {
                CallbackHandler callback = RSSecurityUtils.getCallbackHandler(message, ((Object)((Object)this)).getClass());
                WSPasswordCallback passwordCallback = new WSPasswordCallback(alias, 1);
                callback.handle(new Callback[]{passwordCallback});
                PrivateKey privateKey = crypto.getPrivateKey(alias, passwordCallback.getPassword());
                properties.setDecryptionKey((Key)privateKey);
            }
        }
    }

    private Crypto getSignatureCrypto(Message message) {
        String cryptoKey = null;
        String propKey = null;
        if (RSSecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "security.encryption.crypto";
            propKey = "security.encryption.properties";
        } else {
            cryptoKey = "security.signature.crypto";
            propKey = "security.signature.properties";
        }
        try {
            return new CryptoLoader().getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
            return null;
        }
    }

    private void configureSignatureKeys(Crypto sigCrypto, Message message, XMLSecurityProperties properties) throws IOException, UnsupportedCallbackException, WSSecurityException {
        if (sigCrypto != null && this.signatureVerificationAlias != null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(this.signatureVerificationAlias);
            X509Certificate[] certs = sigCrypto.getX509Certificates(cryptoType);
            if (certs != null && certs.length > 0) {
                properties.setSignatureVerificationKey((Key)certs[0].getPublicKey());
            }
        } else if (sigCrypto != null && this.sigProps != null && this.sigProps.getKeyNameAliasMap() != null) {
            Map<String, String> keyNameAliasMap = this.sigProps.getKeyNameAliasMap();
            for (Map.Entry<String, String> mapping : keyNameAliasMap.entrySet()) {
                CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                cryptoType.setAlias(mapping.getValue());
                X509Certificate[] certs = sigCrypto.getX509Certificates(cryptoType);
                if (certs == null || certs.length <= 0) continue;
                properties.addKeyNameMapping(mapping.getKey(), (Key)certs[0].getPublicKey());
            }
        }
    }

    protected SecurityEventListener configureSecurityEventListener(final Crypto sigCrypto, final Message msg, XMLSecurityProperties securityProperties) {
        final LinkedList incomingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
                if (securityEvent.getSecurityEventType() == SecurityEventConstants.AlgorithmSuite) {
                    if (XmlSecInInterceptor.this.encryptionProperties != null) {
                        XmlSecInInterceptor.this.checkEncryptionAlgorithms((AlgorithmSuiteSecurityEvent)securityEvent);
                    }
                    if (XmlSecInInterceptor.this.sigProps != null) {
                        XmlSecInInterceptor.this.checkSignatureAlgorithms((AlgorithmSuiteSecurityEvent)securityEvent);
                    }
                } else if (securityEvent.getSecurityEventType() != SecurityEventConstants.EncryptedKeyToken && securityEvent instanceof TokenSecurityEvent) {
                    XmlSecInInterceptor.this.checkSignatureTrust(sigCrypto, msg, (TokenSecurityEvent)securityEvent);
                }
                incomingSecurityEventList.add(securityEvent);
            }
        };
        msg.getExchange().put((Object)(SecurityEvent.class.getName() + ".in"), incomingSecurityEventList);
        msg.put((Object)(SecurityEvent.class.getName() + ".in"), incomingSecurityEventList);
        return securityEventListener;
    }

    private void checkEncryptionAlgorithms(AlgorithmSuiteSecurityEvent event) throws XMLSecurityException {
        if (XMLSecurityConstants.Enc.equals((Object)event.getAlgorithmUsage()) && this.encryptionProperties.getEncryptionSymmetricKeyAlgo() != null && !this.encryptionProperties.getEncryptionSymmetricKeyAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The symmetric encryption algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if ((XMLSecurityConstants.Sym_Key_Wrap.equals((Object)event.getAlgorithmUsage()) || XMLSecurityConstants.Asym_Key_Wrap.equals((Object)event.getAlgorithmUsage())) && this.encryptionProperties.getEncryptionKeyTransportAlgo() != null && !this.encryptionProperties.getEncryptionKeyTransportAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The key transport algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.EncDig.equals((Object)event.getAlgorithmUsage()) && this.encryptionProperties.getEncryptionDigestAlgo() != null && !this.encryptionProperties.getEncryptionDigestAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The encryption digest algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
    }

    private void checkSignatureAlgorithms(AlgorithmSuiteSecurityEvent event) throws XMLSecurityException {
        if ((XMLSecurityConstants.Asym_Sig.equals((Object)event.getAlgorithmUsage()) || XMLSecurityConstants.Sym_Sig.equals((Object)event.getAlgorithmUsage())) && this.sigProps.getSignatureAlgo() != null && !this.sigProps.getSignatureAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigDig.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureDigestAlgo() != null && !this.sigProps.getSignatureDigestAlgo().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature digest algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigC14n.equals((Object)event.getAlgorithmUsage()) && this.sigProps.getSignatureC14nMethod() != null && !this.sigProps.getSignatureC14nMethod().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature c14n algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
        if (XMLSecurityConstants.SigTransform.equals((Object)event.getAlgorithmUsage()) && !"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(event.getAlgorithmURI()) && this.sigProps.getSignatureC14nTransform() != null && !this.sigProps.getSignatureC14nTransform().equals(event.getAlgorithmURI())) {
            throw new XMLSecurityException("empty", new Object[]{"The signature transformation algorithm " + event.getAlgorithmURI() + " is not allowed"});
        }
    }

    private void checkSignatureTrust(Crypto sigCrypto, Message msg, TokenSecurityEvent<?> event) throws XMLSecurityException {
        SecurityToken token = event.getSecurityToken();
        if (token != null) {
            X509Certificate[] certs = token.getX509Certificates();
            if (certs == null && token.getPublicKey() == null && token instanceof KeyNameSecurityToken) {
                certs = this.getX509CertificatesForKeyName(sigCrypto, msg, (KeyNameSecurityToken)token);
            }
            PublicKey publicKey = token.getPublicKey();
            X509Certificate cert = null;
            if (certs != null && certs.length > 0) {
                cert = certs[0];
            }
            try {
                new TrustValidator().validateTrust(sigCrypto, cert, publicKey, this.getSubjectContraints(msg));
            }
            catch (WSSecurityException e) {
                String error = "Signature validation failed";
                throw new XMLSecurityException("empty", new Object[]{error});
            }
            if (this.persistSignature) {
                msg.setContent(X509Certificate.class, (Object)cert);
            }
        }
    }

    private X509Certificate[] getX509CertificatesForKeyName(Crypto sigCrypto, Message msg, KeyNameSecurityToken token) throws XMLSecurityException {
        X509Certificate[] certs;
        KeyNameSecurityToken keyNameSecurityToken = token;
        String keyName = keyNameSecurityToken.getKeyName();
        String alias = null;
        if (this.sigProps != null && this.sigProps.getKeyNameAliasMap() != null) {
            alias = this.sigProps.getKeyNameAliasMap().get(keyName);
        }
        try {
            certs = RSSecurityUtils.getCertificates(sigCrypto, alias);
        }
        catch (Exception e) {
            throw new XMLSecurityException("empty", new Object[]{"Error during Signature Trust validation"});
        }
        return certs;
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = JAXRSUtils.toResponseBuilder((int)400).entity((Object)error).type("text/plain").build();
        throw ExceptionUtils.toBadRequestException(null, (Response)response);
    }

    public void setEncryptionProperties(EncryptionProperties properties) {
        this.encryptionProperties = properties;
    }

    public void setSignatureProperties(SignatureProperties properties) {
        this.sigProps = properties;
    }

    public String getDecryptionAlias() {
        return this.decryptionAlias;
    }

    public void setDecryptionAlias(String decryptionAlias) {
        this.decryptionAlias = decryptionAlias;
    }

    public String getSignatureVerificationAlias() {
        return this.signatureVerificationAlias;
    }

    public void setSignatureVerificationAlias(String signatureVerificationAlias) {
        this.signatureVerificationAlias = signatureVerificationAlias;
    }

    public void setPersistSignature(boolean persist) {
        this.persistSignature = persist;
    }

    public boolean isRequireSignature() {
        return this.requireSignature;
    }

    public void setRequireSignature(boolean requireSignature) {
        this.requireSignature = requireSignature;
    }

    public boolean isRequireEncryption() {
        return this.requireEncryption;
    }

    public void setRequireEncryption(boolean requireEncryption) {
        this.requireEncryption = requireEncryption;
    }

    public void setSubjectConstraints(List<String> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns = new ArrayList<Pattern>();
            for (String constraint : constraints) {
                this.subjectDNPatterns.add(Pattern.compile(constraint.trim()));
            }
        }
    }

    private Collection<Pattern> getSubjectContraints(Message msg) throws PatternSyntaxException {
        String[] certConstraintsList;
        String certConstraints = (String)SecurityUtils.getSecurityPropertyValue((String)"security.subject.cert.constraints", (Message)msg);
        if (certConstraints != null && (certConstraintsList = certConstraints.split(",")) != null) {
            this.subjectDNPatterns.clear();
            for (String certConstraint : certConstraintsList) {
                this.subjectDNPatterns.add(Pattern.compile(certConstraint.trim()));
            }
        }
        return this.subjectDNPatterns;
    }

    public Object aroundReadFrom(ReaderInterceptorContext ctx) throws IOException, WebApplicationException {
        Message message = ((ReaderInterceptorContextImpl)ctx).getMessage();
        if (!this.canDocumentBeRead(message)) {
            return ctx.proceed();
        }
        this.prepareMessage(message);
        Object object = ctx.proceed();
        new StaxActionInInterceptor(this.requireSignature, this.requireEncryption).handleMessage(message);
        return object;
    }

    private static class StaxActionInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private static final Logger LOG = LogUtils.getL7dLogger(StaxActionInInterceptor.class);
        private final boolean signatureRequired;
        private final boolean encryptionRequired;

        StaxActionInInterceptor(boolean signatureRequired, boolean encryptionRequired) {
            super("pre-logical");
            this.signatureRequired = signatureRequired;
            this.encryptionRequired = encryptionRequired;
        }

        public void handleMessage(Message message) throws Fault {
            boolean foundEncryptionPart;
            XMLSecurityException ex;
            SecurityEventConstants.Event requiredEvent;
            if (!this.signatureRequired && !this.encryptionRequired) {
                return;
            }
            List incomingSecurityEventList = (List)message.get((Object)(SecurityEvent.class.getName() + ".in"));
            if (incomingSecurityEventList == null) {
                LOG.warning("Security processing failed (actions mismatch)");
                XMLSecurityException ex2 = new XMLSecurityException("empty", new Object[]{"The request was not signed or encrypted"});
                this.throwFault(ex2.getMessage(), (Exception)((Object)ex2));
            }
            if (this.signatureRequired && !this.isEventInResults(requiredEvent = SecurityEventConstants.SignatureValue, incomingSecurityEventList)) {
                LOG.warning("The request was not signed");
                ex = new XMLSecurityException("empty", new Object[]{"The request was not signed"});
                this.throwFault(ex.getMessage(), (Exception)((Object)ex));
            }
            if (this.encryptionRequired && !(foundEncryptionPart = this.isEventInResults(SecurityEventConstants.EncryptedElement, incomingSecurityEventList))) {
                LOG.warning("The request was not encrypted");
                ex = new XMLSecurityException("empty", new Object[]{"The request was not encrypted"});
                this.throwFault(ex.getMessage(), (Exception)((Object)ex));
            }
        }

        private boolean isEventInResults(SecurityEventConstants.Event event, List<SecurityEvent> incomingSecurityEventList) {
            for (SecurityEvent incomingEvent : incomingSecurityEventList) {
                if (event != incomingEvent.getSecurityEventType()) continue;
                return true;
            }
            return false;
        }

        protected void throwFault(String error, Exception ex) {
            LOG.warning(error);
            Response response = JAXRSUtils.toResponseBuilder((int)400).entity((Object)error).build();
            throw ExceptionUtils.toBadRequestException(null, (Response)response);
        }
    }
}

