/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.xml.AbstractXmlSecOutInterceptor;
import org.apache.cxf.rs.security.xml.SignatureProperties;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSigOutInterceptor
extends AbstractXmlSecOutInterceptor {
    public static final String ENVELOPED_SIG = "enveloped";
    public static final String ENVELOPING_SIG = "enveloping";
    public static final String DETACHED_SIG = "detached";
    public static final String DEFAULT_ENV_PREFIX = "env";
    public static final QName DEFAULT_ENV_QNAME = new QName("http://org.apache.cxf/rs/env", "Envelope", "env");
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSigOutInterceptor.class);
    private static final Set<String> SUPPORTED_STYLES = new HashSet<String>(Arrays.asList("enveloped", "enveloping", "detached"));
    private QName envelopeQName = DEFAULT_ENV_QNAME;
    private String sigStyle = "enveloped";
    private boolean keyInfoMustBeAvailable = true;
    private SignatureProperties sigProps = new SignatureProperties();

    public void setSignatureProperties(SignatureProperties props) {
        this.sigProps = props;
    }

    public void setStyle(String style) {
        if (!SUPPORTED_STYLES.contains(style)) {
            throw new IllegalArgumentException("Unsupported XML Signature style");
        }
        this.sigStyle = style;
    }

    public void setKeyInfoMustBeAvailable(boolean use) {
        this.keyInfoMustBeAvailable = use;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigProps.setSignatureAlgo(algo);
    }

    public void setDigestAlgorithm(String algo) {
        this.sigProps.setSignatureDigestAlgo(algo);
    }

    @Override
    protected Document processDocument(Message message, Document doc) throws Exception {
        return this.createSignature(message, doc);
    }

    private Document createSignature(Message message, Document doc) throws Exception {
        String userNameKey = "ws-security.signature.username";
        CryptoLoader loader = new CryptoLoader();
        Crypto crypto = loader.getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties");
        String user = SecurityUtils.getUserName(message, crypto, userNameKey);
        if (StringUtils.isEmpty((String)user) || "useReqSigCert".equals(user)) {
            throw new Exception("User name is not available");
        }
        String password = SecurityUtils.getPassword(message, user, 3, ((Object)((Object)this)).getClass());
        X509Certificate[] issuerCerts = SecurityUtils.getCertificates(crypto, user);
        String sigAlgo = this.sigProps.getSignatureAlgo() == null ? "http://www.w3.org/2000/09/xmldsig#rsa-sha1" : this.sigProps.getSignatureAlgo();
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        PrivateKey privateKey = null;
        try {
            privateKey = crypto.getPrivateKey(user, password);
        }
        catch (Exception ex) {
            String errorMessage = "Private key can not be loaded, user:" + user;
            LOG.severe(errorMessage);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
        String id = UUID.randomUUID().toString();
        String referenceId = "#" + id;
        String digestAlgo = this.sigProps.getSignatureDigestAlgo() == null ? "http://www.w3.org/2000/09/xmldsig#sha1" : this.sigProps.getSignatureDigestAlgo();
        XMLSignature sig = null;
        sig = ENVELOPING_SIG.equals(this.sigStyle) ? this.prepareEnvelopingSignature(doc, id, referenceId, sigAlgo, digestAlgo) : (DETACHED_SIG.equals(this.sigStyle) ? this.prepareDetachedSignature(doc, id, referenceId, sigAlgo, digestAlgo) : this.prepareEnvelopedSignature(doc, id, referenceId, sigAlgo, digestAlgo));
        if (this.keyInfoMustBeAvailable) {
            sig.addKeyInfo(issuerCerts[0]);
            sig.addKeyInfo(issuerCerts[0].getPublicKey());
        }
        sig.sign((Key)privateKey);
        return sig.getElement().getOwnerDocument();
    }

    private XMLSignature prepareEnvelopingSignature(Document doc, String id, String referenceId, String sigAlgo, String digestAlgo) throws Exception {
        Element docEl = doc.getDocumentElement();
        Document newDoc = DOMUtils.createDocument();
        doc.removeChild(docEl);
        newDoc.adoptNode(docEl);
        Element object = newDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Object");
        object.appendChild(docEl);
        docEl.setAttributeNS(null, "ID", id);
        docEl.setIdAttributeNS(null, "ID", true);
        XMLSignature sig = new XMLSignature(newDoc, "", sigAlgo);
        newDoc.appendChild(sig.getElement());
        sig.getElement().appendChild(object);
        Transforms transforms = new Transforms(newDoc);
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addDocument(referenceId, transforms, digestAlgo);
        return sig;
    }

    private XMLSignature prepareDetachedSignature(Document doc, String id, String referenceId, String sigAlgo, String digestAlgo) throws Exception {
        Element docEl = doc.getDocumentElement();
        Document newDoc = DOMUtils.createDocument();
        doc.removeChild(docEl);
        newDoc.adoptNode(docEl);
        docEl.setAttributeNS(null, "ID", id);
        docEl.setIdAttributeNS(null, "ID", true);
        Element root = newDoc.createElementNS(this.envelopeQName.getNamespaceURI(), this.envelopeQName.getPrefix() + ":" + this.envelopeQName.getLocalPart());
        root.appendChild(docEl);
        newDoc.appendChild(root);
        XMLSignature sig = new XMLSignature(newDoc, "", sigAlgo);
        root.appendChild(sig.getElement());
        Transforms transforms = new Transforms(newDoc);
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addDocument(referenceId, transforms, digestAlgo);
        return sig;
    }

    private XMLSignature prepareEnvelopedSignature(Document doc, String id, String referenceURI, String sigAlgo, String digestAlgo) throws Exception {
        doc.getDocumentElement().setAttributeNS(null, "ID", id);
        doc.getDocumentElement().setIdAttributeNS(null, "ID", true);
        XMLSignature sig = new XMLSignature(doc, "", sigAlgo);
        doc.getDocumentElement().appendChild(sig.getElement());
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addDocument(referenceURI, transforms, digestAlgo);
        return sig;
    }

    public void setEnvelopeName(String expandedName) {
        this.setEnvelopeQName(DOMUtils.convertStringToQName((String)expandedName, (String)DEFAULT_ENV_PREFIX));
    }

    public void setEnvelopeQName(QName name) {
        if (name.getPrefix().length() == 0) {
            name = new QName(name.getNamespaceURI(), name.getLocalPart(), DEFAULT_ENV_PREFIX);
        }
        this.envelopeQName = name;
    }
}

