/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collections;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.filter.SamlRequestInfo;
import org.apache.cxf.rs.security.saml.sso.filter.SamlpRequestComponentBuilder;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.DOM2Writer;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractServiceProviderFilter
implements RequestHandler {
    protected static final String SAML_REQUEST = "SAMLRequest";
    protected static final String RELAY_STATE = "RelayState";
    private String idpServiceAddress;
    private String issuerId;

    protected boolean checkSecurityContext(Message m) {
        return false;
    }

    public void setIdpServiceAddress(String idpServiceAddress) {
        this.idpServiceAddress = idpServiceAddress;
    }

    public String getIdpServiceAddress() {
        return this.idpServiceAddress;
    }

    protected AuthnRequest createAuthnRequest(Message m, Document doc) throws Exception {
        Issuer issuer = SamlpRequestComponentBuilder.createIssuer(this.issuerId);
        NameIDPolicy nameIDPolicy = SamlpRequestComponentBuilder.createNameIDPolicy(true, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "Issuer");
        AuthnContextClassRef authnCtxClassRef = SamlpRequestComponentBuilder.createAuthnCtxClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext authnCtx = SamlpRequestComponentBuilder.createRequestedAuthnCtxPolicy(AuthnContextComparisonTypeEnumeration.EXACT, Collections.singletonList(authnCtxClassRef), null);
        UriInfoImpl ui = new UriInfoImpl(m);
        return SamlpRequestComponentBuilder.createAuthnRequest(ui.getRequestUri().toString(), false, false, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", SAMLVersion.VERSION_20, issuer, nameIDPolicy, authnCtx);
    }

    protected String encodeAuthnRequest(Element authnRequestElement) throws MarshallingException, IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequestElement);
        DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
        byte[] deflatedBytes = encoder.deflateToken(requestMessage.getBytes("UTF-8"));
        String encodedRequestMessage = Base64Utility.encode((byte[])deflatedBytes);
        return URLEncoder.encode(encodedRequestMessage, "UTF-8");
    }

    protected SamlRequestInfo createSamlResponseInfo(Message m) throws Exception {
        Document doc = DOMUtils.createDocument();
        doc.appendChild(doc.createElement("root"));
        AuthnRequest authnRequest = this.createAuthnRequest(m, doc);
        Element authnRequestElement = OpenSAMLUtil.toDom((XMLObject)authnRequest, (Document)doc);
        String authnRequestEncoded = this.encodeAuthnRequest(authnRequestElement);
        SamlRequestInfo info = new SamlRequestInfo();
        info.setEncodedSamlRequest(authnRequestEncoded);
        return info;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }
}

