/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.AuthenticationMethod;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;

@Provider
@PreMatching
@Priority(value=1000)
public class OAuthRequestFilter
extends AbstractAccessTokenValidator
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(OAuthRequestFilter.class);
    private boolean useUserSubject;
    private String audience;
    private String issuer;
    private boolean completeAudienceMatch;
    private boolean audienceIsEndpointAddress = true;
    private boolean checkFormData;
    private List<String> requiredScopes = Collections.emptyList();
    private boolean allPermissionsMatch;
    private boolean blockPublicClients;
    private AuthenticationMethod am;

    public void filter(ContainerRequestContext context) {
        this.validateRequest(JAXRSUtils.getCurrentMessage());
    }

    protected void validateRequest(Message m) {
        String remoteAddress;
        String message;
        if (this.isCorsRequest(m)) {
            return;
        }
        String[] authParts = this.getAuthorizationParts(m);
        if (authParts.length < 2) {
            throw ExceptionUtils.toForbiddenException(null, null);
        }
        String authScheme = authParts[0];
        String authSchemeData = authParts[1];
        AccessTokenValidation accessTokenV = this.getAccessTokenValidation(authScheme, authSchemeData, null);
        if (!accessTokenV.isInitialValidationSuccessful()) {
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        String validAudience = this.validateAudiences(accessTokenV.getAudiences());
        if (this.issuer != null && !this.issuer.equals(accessTokenV.getTokenIssuer())) {
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        List<OAuthPermission> permissions = accessTokenV.getTokenScopes();
        ArrayList<OAuthPermission> matchingPermissions = new ArrayList<OAuthPermission>();
        HttpServletRequest req = this.getMessageContext().getHttpServletRequest();
        for (OAuthPermission perm : permissions) {
            boolean uriOK = this.checkRequestURI(req, perm.getUris());
            boolean verbOK = this.checkHttpVerb(req, perm.getHttpVerbs());
            boolean scopeOk = this.checkScopeProperty(perm.getPermission());
            if (!uriOK || !verbOK || !scopeOk) continue;
            matchingPermissions.add(perm);
        }
        if (!permissions.isEmpty() && matchingPermissions.isEmpty() || this.allPermissionsMatch && matchingPermissions.size() != permissions.size() || !this.requiredScopes.isEmpty() && this.requiredScopes.size() != matchingPermissions.size()) {
            message = "Client has no valid permissions";
            LOG.warning(message);
            throw ExceptionUtils.toForbiddenException(null, null);
        }
        if (accessTokenV.getClientIpAddress() != null && ((remoteAddress = this.getMessageContext().getHttpServletRequest().getRemoteAddr()) == null || accessTokenV.getClientIpAddress().equals(remoteAddress))) {
            String message2 = "Client IP Address is invalid";
            LOG.warning(message2);
            throw ExceptionUtils.toForbiddenException(null, null);
        }
        if (this.blockPublicClients && !accessTokenV.isClientConfidential()) {
            message = "Only Confidential Clients are supported";
            LOG.warning(message);
            throw ExceptionUtils.toForbiddenException(null, null);
        }
        if (this.am != null && !this.am.equals((Object)accessTokenV.getTokenSubject().getAuthenticationMethod())) {
            message = "The token has been authorized by the resource owner using an unsupported authentication method";
            LOG.warning(message);
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        String certThumbprint = accessTokenV.getExtraProps().get("x5t#S256");
        if (certThumbprint != null) {
            X509Certificate cert;
            TLSSessionInfo tlsInfo = this.getTlsSessionInfo();
            X509Certificate x509Certificate = cert = tlsInfo == null ? null : OAuthUtils.getRootTLSCertificate(tlsInfo);
            if (cert == null || !OAuthUtils.compareCertificateThumbprints(cert, certThumbprint)) {
                throw ExceptionUtils.toNotAuthorizedException(null, null);
            }
        }
        SecurityContext sc = this.createSecurityContext(req, accessTokenV);
        m.put(SecurityContext.class, (Object)sc);
        OAuthContext oauthContext = new OAuthContext(accessTokenV.getTokenSubject(), accessTokenV.getClientSubject(), matchingPermissions, accessTokenV.getTokenGrantType());
        oauthContext.setClientId(accessTokenV.getClientId());
        oauthContext.setClientConfidential(accessTokenV.isClientConfidential());
        oauthContext.setTokenKey(accessTokenV.getTokenKey());
        oauthContext.setTokenAudience(validAudience);
        oauthContext.setTokenIssuer(accessTokenV.getTokenIssuer());
        oauthContext.setTokenRequestParts(authParts);
        oauthContext.setTokenExtraProperties(accessTokenV.getExtraProps());
        m.setContent(OAuthContext.class, (Object)oauthContext);
    }

    protected boolean checkHttpVerb(HttpServletRequest req, List<String> verbs) {
        if (!verbs.isEmpty() && !verbs.contains(req.getMethod())) {
            String message = "Invalid http verb";
            LOG.fine(message);
            return false;
        }
        return true;
    }

    protected boolean checkRequestURI(HttpServletRequest request, List<String> uris) {
        if (uris.isEmpty()) {
            return true;
        }
        String servletPath = request.getPathInfo();
        boolean foundValidScope = false;
        for (String uri : uris) {
            if (!OAuthUtils.checkRequestURI(servletPath, uri)) continue;
            foundValidScope = true;
            break;
        }
        if (!foundValidScope) {
            String message = "Invalid request URI: " + request.getRequestURL().toString();
            LOG.fine(message);
        }
        return foundValidScope;
    }

    protected boolean checkScopeProperty(String scope) {
        if (!this.requiredScopes.isEmpty()) {
            return this.requiredScopes.contains(scope);
        }
        return true;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.useUserSubject = useUserSubject;
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, AccessTokenValidation accessTokenV) {
        UserSubject resourceOwnerSubject = accessTokenV.getTokenSubject();
        UserSubject clientSubject = accessTokenV.getClientSubject();
        final UserSubject theSubject = this.useUserSubject ? resourceOwnerSubject : clientSubject;
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return theSubject != null ? new SimplePrincipal(theSubject.getLogin()) : null;
            }

            public boolean isUserInRole(String role) {
                if (theSubject == null) {
                    return false;
                }
                return theSubject.getRoles().contains(role);
            }
        };
    }

    protected boolean isCorsRequest(Message m) {
        return PropertyUtils.isTrue((Object)m.get((Object)"local_preflight"));
    }

    protected String validateAudiences(List<String> audiences) {
        if (StringUtils.isEmpty(audiences) && this.audience == null) {
            return null;
        }
        if (this.audience != null) {
            if (audiences.contains(this.audience)) {
                return this.audience;
            }
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        if (!this.audienceIsEndpointAddress) {
            return null;
        }
        String requestPath = (String)PhaseInterceptorChain.getCurrentMessage().get((Object)"org.apache.cxf.request.url");
        for (String s : audiences) {
            boolean matched = this.completeAudienceMatch ? requestPath.equals(s) : requestPath.startsWith(s);
            if (!matched) continue;
            return s;
        }
        AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        return null;
    }

    public void setCheckFormData(boolean checkFormData) {
        this.checkFormData = checkFormData;
    }

    protected String[] getAuthorizationParts(Message m) {
        if (!this.checkFormData) {
            return AuthorizationUtils.getAuthorizationParts(this.getMessageContext(), this.supportedSchemes);
        }
        return new String[]{"Bearer", this.getTokenFromFormData(m)};
    }

    protected String getTokenFromFormData(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String type = (String)message.get((Object)"Content-Type");
        if (type != null && "application/x-www-form-urlencoded".startsWith(type) && method != null && (method.equals("POST") || method.equals("PUT"))) {
            try {
                FormEncodingProvider provider = new FormEncodingProvider(true);
                Form form = FormUtils.readForm((FormEncodingProvider)provider, (Message)message);
                MultivaluedMap formData = form.asMap();
                String token = (String)formData.getFirst((Object)"access_token");
                if (token != null) {
                    FormUtils.restoreForm((FormEncodingProvider)provider, (Form)form, (Message)message);
                    return token;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        return null;
    }

    public void setRequiredScopes(List<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
    }

    public void setAllPermissionsMatch(boolean allPermissionsMatch) {
        this.allPermissionsMatch = allPermissionsMatch;
    }

    public void setBlockPublicClients(boolean blockPublicClients) {
        this.blockPublicClients = blockPublicClients;
    }

    public void setTokenSubjectAuthenticationMethod(AuthenticationMethod method) {
        this.am = method;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public boolean isCompleteAudienceMatch() {
        return this.completeAudienceMatch;
    }

    public void setCompleteAudienceMatch(boolean completeAudienceMatch) {
        this.completeAudienceMatch = completeAudienceMatch;
    }

    public void setAudienceIsEndpointAddress(boolean audienceIsEndpointAddress) {
        this.audienceIsEndpointAddress = audienceIsEndpointAddress;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    private TLSSessionInfo getTlsSessionInfo() {
        return (TLSSessionInfo)this.getMessageContext().get((Object)TLSSessionInfo.class.getName());
    }
}

