/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.JPAOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class JPACodeDataProvider
extends JPAOAuthDataProvider
implements AuthorizationCodeDataProvider {
    private static final String CODE_TABLE_NAME = ServerAuthorizationCodeGrant.class.getSimpleName();
    private long codeLifetime = 600L;

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveCodeGrant(grant);
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        return AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
    }

    protected void saveCodeGrant(ServerAuthorizationCodeGrant grant) {
        this.getEntityManager().getTransaction().begin();
        if (grant.getSubject() != null) {
            UserSubject sub = (UserSubject)this.getEntityManager().find(UserSubject.class, (Object)grant.getSubject().getLogin());
            if (sub == null) {
                this.getEntityManager().persist((Object)grant.getSubject());
            } else {
                sub = (UserSubject)this.getEntityManager().merge((Object)grant.getSubject());
                grant.setSubject(sub);
            }
        }
        this.getEntityManager().persist((Object)grant);
        this.getEntityManager().getTransaction().commit();
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.removeClientCodeGrants(c);
        super.doRemoveClient(c);
    }

    protected void removeClientCodeGrants(Client c) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c, null)) {
            this.removeCodeGrant(grant.getCode());
        }
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = (ServerAuthorizationCodeGrant)this.getEntityManager().find(ServerAuthorizationCodeGrant.class, (Object)code);
        if (grant != null) {
            this.removeEntity(grant);
        }
        return grant;
    }

    @Override
    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client c, UserSubject subject) throws OAuthServiceException {
        return this.getCodesQuery(c, subject).getResultList();
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }

    protected TypedQuery<ServerAuthorizationCodeGrant> getCodesQuery(Client c, UserSubject resourceOwnerSubject) {
        if (c == null && resourceOwnerSubject == null) {
            return this.getEntityManager().createQuery("SELECT c FROM " + CODE_TABLE_NAME + " c", ServerAuthorizationCodeGrant.class);
        }
        if (c == null) {
            return this.getEntityManager().createQuery("SELECT c FROM " + CODE_TABLE_NAME + " c JOIN c.subject s WHERE s.login = '" + resourceOwnerSubject.getLogin() + "'", ServerAuthorizationCodeGrant.class);
        }
        if (resourceOwnerSubject == null) {
            return this.getEntityManager().createQuery("SELECT code FROM " + CODE_TABLE_NAME + " code JOIN code.client c WHERE c.clientId = '" + c.getClientId() + "'", ServerAuthorizationCodeGrant.class);
        }
        return this.getEntityManager().createQuery("SELECT code FROM " + CODE_TABLE_NAME + " code JOIN code.subject s JOIN code.client c WHERE s.login = '" + resourceOwnerSubject.getLogin() + "' AND c.clientId = '" + c.getClientId() + "'", ServerAuthorizationCodeGrant.class);
    }
}

