/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.cache.Cache;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.JCacheOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class JCacheCodeDataProvider
extends JCacheOAuthDataProvider
implements AuthorizationCodeDataProvider {
    public static final String CODE_GRANT_CACHE_KEY = "cxf.oauth2.codegrant.cache";
    private long codeLifetime = 600L;
    private Cache<String, ServerAuthorizationCodeGrant> grantCache;

    protected JCacheCodeDataProvider() throws Exception {
        this("cxf-oauth2-ehcache3.xml", BusFactory.getThreadDefaultBus((boolean)true));
    }

    protected JCacheCodeDataProvider(String configFileURL, Bus bus) throws Exception {
        this(configFileURL, bus, "cxf.oauth2.client.cache", CODE_GRANT_CACHE_KEY, "cxf.oauth2.accesstoken.cache", "cxf.oauth2.refreshtoken.cache");
    }

    protected JCacheCodeDataProvider(String configFileURL, Bus bus, String clientCacheKey, String codeCacheKey, String accessTokenKey, String refreshTokenKey) throws Exception {
        super(configFileURL, bus, clientCacheKey, accessTokenKey, refreshTokenKey);
        this.grantCache = JCacheCodeDataProvider.createCache(this.cacheManager, codeCacheKey, String.class, ServerAuthorizationCodeGrant.class);
    }

    @Override
    protected void doRemoveClient(Client c) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c, null)) {
            this.removeCodeGrant(grant.getCode());
        }
        super.doRemoveClient(c);
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
        this.grantCache.put((Object)grant.getCode(), (Object)grant);
        return grant;
    }

    @Override
    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client c, UserSubject sub) {
        HashSet<Object> toRemove = new HashSet<Object>();
        ArrayList<ServerAuthorizationCodeGrant> grants = new ArrayList<ServerAuthorizationCodeGrant>();
        for (Cache.Entry entry : this.grantCache) {
            ServerAuthorizationCodeGrant grant = (ServerAuthorizationCodeGrant)entry.getValue();
            if (!JCacheCodeDataProvider.isExpired(grant)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (!AbstractCodeDataProvider.isCodeMatched(grant, c, sub)) continue;
            grants.add(grant);
        }
        this.grantCache.removeAll(toRemove);
        return grants;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.getCodeGrant(code);
        if (grant != null) {
            this.grantCache.remove((Object)code);
        }
        return grant;
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }

    protected ServerAuthorizationCodeGrant getCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = (ServerAuthorizationCodeGrant)this.grantCache.get((Object)code);
        if (grant != null && JCacheCodeDataProvider.isExpired(grant)) {
            this.grantCache.remove((Object)code);
            grant = null;
        }
        return grant;
    }

    protected static boolean isExpired(ServerAuthorizationCodeGrant grant) {
        return System.currentTimeMillis() < grant.getIssuedAt() + grant.getExpiresIn();
    }
}

