/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils.crypto;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.common.util.CompressionUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.oauth2.utils.Base64UrlUtility;
import org.apache.cxf.rs.security.oauth2.utils.crypto.KeyProperties;

public final class CryptoUtils {
    private CryptoUtils() {
    }

    public static String encodeSecretKey(SecretKey key) throws SecurityException {
        return CryptoUtils.encodeBytes(key.getEncoded());
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey) throws SecurityException {
        KeyProperties props = new KeyProperties(publicKey.getAlgorithm());
        return CryptoUtils.encryptSecretKey(secretKey, publicKey, props);
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey, KeyProperties props) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.encryptBytes(secretKey.getEncoded(), publicKey, props);
        return CryptoUtils.encodeBytes(encryptedBytes);
    }

    public static RSAPublicKey getRSAPublicKey(String encodedModulus, String encodedPublicExponent) {
        try {
            return CryptoUtils.getRSAPublicKey(Base64UrlUtility.decode(encodedModulus), Base64UrlUtility.decode(encodedPublicExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPublicKey getRSAPublicKey(byte[] modulusBytes, byte[] publicExponentBytes) {
        try {
            return CryptoUtils.getRSAPublicKey(KeyFactory.getInstance("RSA"), modulusBytes, publicExponentBytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPublicKey getRSAPublicKey(KeyFactory factory, byte[] modulusBytes, byte[] publicExponentBytes) {
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger publicExponent = new BigInteger(1, publicExponentBytes);
        try {
            return (RSAPublicKey)factory.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(String encodedModulus, String encodedPrivateExponent) {
        try {
            return CryptoUtils.getRSAPrivateKey(Base64UrlUtility.decode(encodedModulus), Base64UrlUtility.decode(encodedPrivateExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static byte[] signData(byte[] data, PrivateKey key, String signAlgo) {
        return CryptoUtils.signData(data, key, signAlgo, null, null);
    }

    public static byte[] signData(byte[] data, PrivateKey key, String signAlgo, SecureRandom random, AlgorithmParameterSpec params) {
        try {
            Signature s = Signature.getInstance(signAlgo);
            if (random == null) {
                s.initSign(key);
            } else {
                s.initSign(key, random);
            }
            if (params != null) {
                s.setParameter(params);
            }
            s.update(data);
            return s.sign();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static void verifySignature(byte[] data, byte[] signature, PublicKey key, String signAlgo) {
        CryptoUtils.verifySignature(data, signature, key, signAlgo, null);
    }

    public static void verifySignature(byte[] data, byte[] signature, PublicKey key, String signAlgo, AlgorithmParameterSpec params) {
        try {
            Signature s = Signature.getInstance(signAlgo);
            s.initVerify(key);
            if (params != null) {
                s.setParameter(params);
            }
            s.update(data);
            s.verify(signature);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(byte[] modulusBytes, byte[] privateExponentBytes) {
        try {
            return CryptoUtils.getRSAPrivateKey(KeyFactory.getInstance("RSA"), modulusBytes, privateExponentBytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(KeyFactory factory, byte[] modulusBytes, byte[] privateExponentBytes) {
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger privateExponent = new BigInteger(1, privateExponentBytes);
        try {
            return (RSAPrivateKey)factory.generatePrivate(new RSAPrivateKeySpec(modulus, privateExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static SecretKey getSecretKey(String symEncAlgo) throws SecurityException {
        return CryptoUtils.getSecretKey(new KeyProperties(symEncAlgo));
    }

    public static SecretKey getSecretKey(KeyProperties props) throws SecurityException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(props.getKeyAlgo());
            AlgorithmParameterSpec algoSpec = props.getAlgoSpec();
            SecureRandom random = props.getSecureRandom();
            if (algoSpec != null) {
                if (random != null) {
                    keyGen.init(algoSpec, random);
                } else {
                    keyGen.init(algoSpec);
                }
            } else {
                int keySize = props.getKeySize();
                if (keySize == -1) {
                    keySize = 128;
                }
                if (random != null) {
                    keyGen.init(keySize, random);
                } else {
                    keyGen.init(keySize);
                }
            }
            return keyGen.generateKey();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String decryptSequence(String encodedToken, String encodedSecretKey) throws SecurityException {
        return CryptoUtils.decryptSequence(encodedToken, encodedSecretKey, new KeyProperties("AES"));
    }

    public static String decryptSequence(String encodedData, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey(encodedSecretKey, props.getKeyAlgo());
        return CryptoUtils.decryptSequence(encodedData, key, props);
    }

    public static String decryptSequence(String encodedData, Key secretKey) throws SecurityException {
        return CryptoUtils.decryptSequence(encodedData, secretKey, null);
    }

    public static String decryptSequence(String encodedData, Key secretKey, KeyProperties props) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.decodeSequence(encodedData);
        byte[] bytes = CryptoUtils.decryptBytes(encryptedBytes, secretKey, props);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String encryptSequence(String sequence, Key secretKey) throws SecurityException {
        return CryptoUtils.encryptSequence(sequence, secretKey, null);
    }

    public static String encryptSequence(String sequence, Key secretKey, KeyProperties keyProps) throws SecurityException {
        try {
            byte[] bytes = CryptoUtils.encryptBytes(sequence.getBytes("UTF-8"), secretKey, keyProps);
            return CryptoUtils.encodeBytes(bytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String encodeBytes(byte[] bytes) throws SecurityException {
        try {
            return Base64UrlUtility.encode(bytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey) throws SecurityException {
        return CryptoUtils.encryptBytes(bytes, secretKey, null);
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey, KeyProperties keyProps) throws SecurityException {
        return CryptoUtils.processBytes(bytes, secretKey, keyProps, 1);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey) throws SecurityException {
        return CryptoUtils.decryptBytes(bytes, secretKey, null);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey, KeyProperties keyProps) throws SecurityException {
        return CryptoUtils.processBytes(bytes, secretKey, keyProps, 2);
    }

    public static byte[] wrapSecretKey(byte[] keyBytes, String keyAlgo, Key wrapperKey, String wrapperKeyAlgo) throws SecurityException {
        return CryptoUtils.wrapSecretKey(new SecretKeySpec(keyBytes, keyAlgo), wrapperKey, new KeyProperties(wrapperKeyAlgo));
    }

    public static byte[] wrapSecretKey(SecretKey secretKey, Key wrapperKey, KeyProperties keyProps) throws SecurityException {
        try {
            Cipher c = CryptoUtils.initCipher(wrapperKey, keyProps, 3);
            return c.wrap(secretKey);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static SecretKey unwrapSecretKey(byte[] wrappedBytes, String wrappedKeyAlgo, Key unwrapperKey, String unwrapperKeyAlgo) throws SecurityException {
        return CryptoUtils.unwrapSecretKey(wrappedBytes, wrappedKeyAlgo, unwrapperKey, new KeyProperties(unwrapperKeyAlgo));
    }

    public static SecretKey unwrapSecretKey(byte[] wrappedBytes, String wrappedKeyAlgo, Key unwrapperKey, KeyProperties keyProps) throws SecurityException {
        try {
            Cipher c = CryptoUtils.initCipher(unwrapperKey, keyProps, 4);
            return (SecretKey)c.unwrap(wrappedBytes, wrappedKeyAlgo, 3);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] processBytes(byte[] bytes, Key secretKey, KeyProperties keyProps, int mode) throws SecurityException {
        boolean compressionSupported;
        boolean bl = compressionSupported = keyProps != null && keyProps.isCompressionSupported();
        if (compressionSupported && mode == 1) {
            bytes = CompressionUtils.deflate((byte[])bytes, (boolean)false);
        }
        try {
            int blockSize;
            Cipher c = CryptoUtils.initCipher(secretKey, keyProps, mode);
            byte[] result = new byte[]{};
            int n = blockSize = keyProps != null ? keyProps.getBlockSize() : -1;
            if (secretKey instanceof SecretKey && blockSize == -1) {
                result = c.doFinal(bytes);
            } else {
                if (blockSize == -1) {
                    blockSize = secretKey instanceof PublicKey ? 117 : 128;
                }
                int offset = 0;
                while (offset + blockSize < bytes.length) {
                    result = CryptoUtils.addToResult(result, c.doFinal(bytes, offset, blockSize));
                    offset += blockSize;
                }
                if (offset < bytes.length) {
                    result = CryptoUtils.addToResult(result, c.doFinal(bytes, offset, bytes.length - offset));
                }
            }
            if (compressionSupported && mode == 2) {
                result = IOUtils.readBytesFromStream((InputStream)CompressionUtils.inflate((byte[])result, (boolean)false));
            }
            return result;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static Cipher initCipher(Key secretKey, KeyProperties keyProps, int mode) throws SecurityException {
        try {
            String algorithm = keyProps != null && keyProps.getKeyAlgo() != null ? keyProps.getKeyAlgo() : secretKey.getAlgorithm();
            Cipher c = Cipher.getInstance(algorithm);
            if (keyProps == null || keyProps.getAlgoSpec() == null && keyProps.getSecureRandom() == null) {
                c.init(mode, secretKey);
            } else {
                AlgorithmParameterSpec algoSpec = keyProps.getAlgoSpec();
                SecureRandom random = keyProps.getSecureRandom();
                if (algoSpec == null) {
                    c.init(mode, secretKey, random);
                } else if (random == null) {
                    c.init(mode, secretKey, algoSpec);
                } else {
                    c.init(mode, secretKey, algoSpec, random);
                }
            }
            if (keyProps != null && keyProps.getAdditionalData() != null) {
                Method m = Cipher.class.getMethod("updateAAD", byte[].class);
                m.invoke((Object)c, new Object[]{keyProps.getAdditionalData()});
            }
            return c;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] addToResult(byte[] prefix, byte[] suffix) {
        byte[] result = new byte[prefix.length + suffix.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(suffix, 0, result, prefix.length, suffix.length);
        return result;
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey) throws SecurityException {
        return CryptoUtils.decodeSecretKey(encodedSecretKey, "AES");
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey, String secretKeyAlgo) throws SecurityException {
        byte[] secretKeyBytes = CryptoUtils.decodeSequence(encodedSecretKey);
        return CryptoUtils.createSecretKeySpec(secretKeyBytes, secretKeyAlgo);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, PrivateKey privateKey) {
        return CryptoUtils.decryptSecretKey(encodedEncryptedSecretKey, "AES", privateKey);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, String secretKeyAlgo, PrivateKey privateKey) throws SecurityException {
        KeyProperties props = new KeyProperties(privateKey.getAlgorithm());
        return CryptoUtils.decryptSecretKey(encodedEncryptedSecretKey, secretKeyAlgo, props, privateKey);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, String secretKeyAlgo, KeyProperties props, PrivateKey privateKey) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.decodeSequence(encodedEncryptedSecretKey);
        byte[] descryptedBytes = CryptoUtils.decryptBytes(encryptedBytes, privateKey, props);
        return CryptoUtils.createSecretKeySpec(descryptedBytes, secretKeyAlgo);
    }

    public static SecretKey createSecretKeySpec(byte[] bytes, String algo) {
        return new SecretKeySpec(bytes, algo);
    }

    public static byte[] decodeSequence(String encodedSequence) throws SecurityException {
        try {
            return Base64UrlUtility.decode(encodedSequence);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }
}

