/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.saml;

import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.message.Message;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;

public class SamlOAuthValidator {
    private String accessTokenServiceAddress;
    private String issuer;
    private String clientAddress;
    private boolean subjectConfirmationDataRequired;

    public void setSubjectConfirmationDataRequired(boolean required) {
        this.subjectConfirmationDataRequired = required;
    }

    public void setAccessTokenServiceAddress(String address) {
        this.accessTokenServiceAddress = address;
    }

    public void setIssuer(String value) {
        this.issuer = value;
    }

    public void setClientAddress(String value) {
        this.issuer = value;
    }

    public void validate(Message message, SamlAssertionWrapper wrapper) {
        Conditions cs = wrapper.getSaml2().getConditions();
        this.validateAudience(message, cs);
        if (this.issuer != null) {
            String expectedIssuer;
            String actualIssuer = this.getIssuer(wrapper);
            String string = expectedIssuer = "client_id".equals(this.issuer) ? wrapper.getSaml2().getSubject().getNameID().getValue() : this.issuer;
            if (actualIssuer == null || !actualIssuer.equals(expectedIssuer)) {
                throw ExceptionUtils.toNotAuthorizedException(null, null);
            }
        }
        if (!this.validateAuthenticationSubject(message, cs, wrapper.getSaml2().getSubject())) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    private String getIssuer(SamlAssertionWrapper assertionW) {
        Issuer samlIssuer = assertionW.getSaml2().getIssuer();
        return samlIssuer == null ? null : samlIssuer.getValue();
    }

    private void validateAudience(Message message, Conditions cs) {
        String absoluteAddress = this.getAbsoluteTargetAddress(message);
        List restrictions = cs.getAudienceRestrictions();
        for (AudienceRestriction ar : restrictions) {
            List audiences = ar.getAudiences();
            for (Audience a : audiences) {
                if (!absoluteAddress.equals(a.getAudienceURI())) continue;
                return;
            }
        }
        throw ExceptionUtils.toNotAuthorizedException(null, null);
    }

    private String getAbsoluteTargetAddress(Message m) {
        if (this.accessTokenServiceAddress == null) {
            return new UriInfoImpl(m).getAbsolutePath().toString();
        }
        if (!this.accessTokenServiceAddress.startsWith("http")) {
            String httpBasePath = (String)m.get((Object)"http.base.path");
            return UriBuilder.fromUri((String)httpBasePath).path(this.accessTokenServiceAddress).build(new Object[0]).toString();
        }
        return this.accessTokenServiceAddress;
    }

    private boolean validateAuthenticationSubject(Message m, Conditions cs, Subject subject) {
        if (subject.getSubjectConfirmations() == null) {
            return false;
        }
        for (SubjectConfirmation subjectConf : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConf.getMethod())) continue;
            this.validateSubjectConfirmation(m, cs, subjectConf.getSubjectConfirmationData());
        }
        return true;
    }

    private void validateSubjectConfirmation(Message m, Conditions cs, SubjectConfirmationData subjectConfData) {
        if (subjectConfData == null) {
            if (!this.subjectConfirmationDataRequired && cs.getNotOnOrAfter() != null && !cs.getNotOnOrAfter().isBeforeNow()) {
                return;
            }
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        String recipient = subjectConfData.getRecipient();
        if (recipient == null || !recipient.equals(this.getAbsoluteTargetAddress(m))) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (subjectConfData.getNotOnOrAfter() == null || subjectConfData.getNotOnOrAfter().isBeforeNow()) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (!(subjectConfData.getAddress() == null || this.clientAddress != null && subjectConfData.getAddress().equals(this.clientAddress))) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }
}

