/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;

public class JAXRSClientFactoryBean
extends AbstractJAXRSFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSClientFactoryBean.class);
    private String username;
    private String password;
    private boolean inheritHeaders;
    private MultivaluedMap<String, String> headers;
    private ClientState initialState;
    private boolean threadSafe;
    private long timeToKeepState;
    private Class<?> serviceClass;
    private ClassLoader proxyLoader;

    public JAXRSClientFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSClientFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        serviceFactory.setEnableStaticResolution(true);
    }

    public void setClassLoader(ClassLoader loader) {
        this.proxyLoader = loader;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setSecondsToKeepState(long time) {
        this.timeToKeepState = time;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInheritHeaders(boolean ih) {
        this.inheritHeaders = ih;
    }

    public void setResourceClass(Class<?> cls) {
        this.setServiceClass(cls);
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
        this.serviceFactory.setResourceClass(cls);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = new MetadataMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] values;
            for (String v : values = entry.getValue().split(",")) {
                if (v.length() == 0) continue;
                this.headers.add((Object)entry.getKey(), (Object)v);
            }
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public WebClient createWebClient() {
        int queryIndex;
        String serviceAddress = this.getAddress();
        int n = queryIndex = serviceAddress != null ? serviceAddress.lastIndexOf(63) : -1;
        if (queryIndex != -1) {
            serviceAddress = serviceAddress.substring(0, queryIndex);
        }
        JAXRSServiceImpl service = new JAXRSServiceImpl(serviceAddress, this.getServiceName());
        this.getServiceFactory().setService((Service)service);
        try {
            Endpoint ep = this.createEndpoint();
            ClientState actualState = this.getActualState();
            WebClient client = actualState == null ? new WebClient(this.getAddress()) : new WebClient(actualState);
            this.initClient(client, ep, actualState == null);
            this.notifyLifecycleManager(client);
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, new Object[]{client, ep});
            return client;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    private void notifyLifecycleManager(Object client) {
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated((org.apache.cxf.endpoint.Client)new FrontendClientAdapter(WebClient.getConfig(client)));
        }
    }

    private ClientState getActualState() {
        if (this.threadSafe) {
            this.initialState = new ThreadLocalClientState(this.getAddress(), this.timeToKeepState);
        }
        if (this.initialState != null) {
            return this.headers != null ? this.initialState.newState(URI.create(this.getAddress()), this.headers, null) : this.initialState;
        }
        return null;
    }

    public <T> T create(Class<T> cls, Object ... varValues) {
        return cls.cast(this.createWithValues(varValues));
    }

    public Client create() {
        if (this.serviceClass == WebClient.class) {
            return this.createWebClient();
        }
        return this.createWithValues(new Object[0]);
    }

    public Client createWithValues(Object ... varValues) {
        this.serviceFactory.setBus(this.getBus());
        this.checkResources(false);
        ClassResourceInfo cri = null;
        try {
            Endpoint ep = this.createEndpoint();
            if (this.getServiceClass() != null) {
                for (ClassResourceInfo info : this.serviceFactory.getClassResourceInfo()) {
                    if (!info.getServiceClass().isAssignableFrom(this.getServiceClass()) && !this.getServiceClass().isAssignableFrom(info.getServiceClass())) continue;
                    cri = info;
                    break;
                }
                if (cri == null) {
                    throw new RuntimeException("Service class " + this.getServiceClass().getName() + " is not recognized");
                }
            } else {
                cri = (ClassResourceInfo)this.serviceFactory.getClassResourceInfo().get(0);
            }
            boolean isRoot = cri.getURITemplate() != null;
            ClientProxyImpl proxyImpl = null;
            ClientState actualState = this.getActualState();
            proxyImpl = actualState == null ? new ClientProxyImpl(URI.create(this.getAddress()), this.proxyLoader, cri, isRoot, this.inheritHeaders, varValues) : new ClientProxyImpl(actualState, this.proxyLoader, cri, isRoot, this.inheritHeaders, varValues);
            this.initClient(proxyImpl, ep, actualState == null);
            ClassLoader theLoader = this.proxyLoader == null ? cri.getServiceClass().getClassLoader() : this.proxyLoader;
            Class[] ifaces = new Class[]{Client.class, InvocationHandlerAware.class, cri.getServiceClass()};
            Client actualClient = (Client)ProxyHelper.getProxy((ClassLoader)theLoader, (Class[])ifaces, (InvocationHandler)proxyImpl);
            this.notifyLifecycleManager(actualClient);
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, new Object[]{actualClient, ep});
            return actualClient;
        }
        catch (IllegalArgumentException ex) {
            String expected;
            String message = ex.getLocalizedMessage();
            if (cri != null && ((expected = cri.getServiceClass().getSimpleName()) + " is not an interface").equals(message)) {
                message = message + "; make sure CGLIB is on the classpath";
            }
            LOG.severe(ex.getClass().getName() + " : " + message);
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    protected ConduitSelector getConduitSelector(Endpoint ep) {
        ConduitSelector cs = this.getConduitSelector();
        if (cs == null) {
            cs = new UpfrontConduitSelector();
        }
        cs.setEndpoint(ep);
        return cs;
    }

    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            ep.getEndpointInfo().addExtensor((Object)authPolicy);
        }
        client.getConfiguration().setConduitSelector(this.getConduitSelector(ep));
        client.getConfiguration().setBus(this.getBus());
        client.getConfiguration().getOutInterceptors().addAll(this.getOutInterceptors());
        client.getConfiguration().getOutInterceptors().addAll(ep.getOutInterceptors());
        client.getConfiguration().getInInterceptors().addAll(this.getInInterceptors());
        client.getConfiguration().getInInterceptors().addAll(ep.getInInterceptors());
        client.getConfiguration().getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        this.applyFeatures(client);
        if (this.headers != null && addHeaders) {
            client.headers(this.headers);
        }
        ClientProviderFactory factory = ClientProviderFactory.createInstance(this.getBus());
        this.setupFactory(factory, ep);
        this.getBus().setProperty(ClientProviderFactory.class.getName(), (Object)factory);
    }

    protected void applyFeatures(AbstractClient client) {
        if (this.getFeatures() != null) {
            for (Feature feature : this.getFeatures()) {
                feature.initialize((InterceptorProvider)client.getConfiguration(), this.getBus());
            }
        }
    }

    public void setInitialState(ClientState initialState) {
        this.initialState = initialState;
    }
}

