/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(WrapperClassInInterceptor.class);

    public WrapperClassInInterceptor() {
        super("post-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Class<?> retType;
        Exchange ex = message.getExchange();
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response")) || boi == null) {
            return;
        }
        Method method = (Method)ex.get(Method.class);
        if (method != null && method.getName().endsWith("Async") && ((retType = method.getReturnType()).getName().equals("java.util.concurrent.Future") || retType.getName().equals("javax.xml.ws.Response"))) {
            return;
        }
        if (boi != null && boi.isUnwrappedCapable()) {
            MessageContentsList newParams;
            Object wrappedObject;
            BindingMessageInfo bmi;
            MessageInfo messageInfo;
            BindingOperationInfo boi2 = boi.getUnwrappedOperation();
            OperationInfo op = boi2.getOperationInfo();
            MessageInfo wrappedMessageInfo = (MessageInfo)message.get(MessageInfo.class);
            if (wrappedMessageInfo == boi.getOperationInfo().getInput()) {
                messageInfo = op.getInput();
                bmi = boi2.getInput();
            } else {
                messageInfo = op.getOutput();
                bmi = boi2.getOutput();
            }
            MessageContentsList lst = MessageContentsList.getContentsList((Message)message);
            if (lst == null) {
                return;
            }
            if (lst != null) {
                message.put(MessageInfo.class, (Object)messageInfo);
                message.put(BindingMessageInfo.class, (Object)bmi);
                ex.put(BindingOperationInfo.class, (Object)boi2);
                ex.put(OperationInfo.class, (Object)op);
            }
            if (this.isGET(message)) {
                LOG.fine("WrapperClassInInterceptor skipped in HTTP GET method");
                return;
            }
            MessagePartInfo wrapperPart = wrappedMessageInfo.getMessagePart(0);
            Class wrapperClass = wrapperPart.getTypeClass();
            if (!wrapperClass.isInstance(wrappedObject = lst.get(wrapperPart.getIndex()))) {
                wrappedObject = null;
                wrapperPart = null;
                wrapperClass = null;
            }
            if (wrapperClass == null || wrappedObject == null) {
                return;
            }
            WrapperHelper helper = (WrapperHelper)wrapperPart.getProperty("WRAPPER_CLASS", WrapperHelper.class);
            if (helper == null) {
                Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
                DataBinding dataBinding = service.getDataBinding();
                if (dataBinding instanceof WrapperCapableDatabinding) {
                    helper = this.createWrapperHelper((WrapperCapableDatabinding)dataBinding, messageInfo, wrappedMessageInfo, wrapperClass);
                    wrapperPart.setProperty("WRAPPER_CLASS", (Object)helper);
                } else {
                    return;
                }
            }
            try {
                newParams = new MessageContentsList(helper.getWrapperParts(wrappedObject));
                ArrayList<Integer> removes = null;
                for (MessagePartInfo part : messageInfo.getMessageParts()) {
                    if (!Boolean.TRUE.equals(part.getProperty("messagepart.isheader"))) continue;
                    MessagePartInfo mpi = wrappedMessageInfo.getMessagePart(part.getName());
                    if (lst.hasValue(mpi)) {
                        newParams.put(part, lst.get(mpi));
                        continue;
                    }
                    if (mpi.getTypeClass() != null) continue;
                    if (removes == null) {
                        removes = new ArrayList<Integer>();
                    }
                    removes.add(mpi.getIndex());
                }
                if (removes != null) {
                    Collections.sort(removes, Collections.reverseOrder());
                    for (Integer i : removes) {
                        newParams.remove(i.intValue());
                    }
                }
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            message.setContent(List.class, (Object)newParams);
        }
    }

    private WrapperHelper createWrapperHelper(WrapperCapableDatabinding dataBinding, MessageInfo messageInfo, MessageInfo wrappedMessageInfo, Class<?> wrapperClass) {
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> elTypeNames = new ArrayList<String>();
        ArrayList<Class> partClasses = new ArrayList<Class>();
        for (MessagePartInfo p : messageInfo.getMessageParts()) {
            if (Boolean.TRUE.equals(p.getProperty("messagepart.isheader"))) {
                int idx = p.getIndex();
                this.ensureSize(elTypeNames, idx);
                this.ensureSize(partClasses, idx);
                this.ensureSize(partNames, idx);
                elTypeNames.set(idx, null);
                partClasses.set(idx, null);
                partNames.set(idx, null);
                continue;
            }
            String elementType = null;
            elementType = p.getTypeQName() == null ? null : p.getTypeQName().getLocalPart();
            int idx = p.getIndex();
            this.ensureSize(elTypeNames, idx);
            this.ensureSize(partClasses, idx);
            this.ensureSize(partNames, idx);
            elTypeNames.set(idx, elementType);
            partClasses.set(idx, p.getTypeClass());
            partNames.set(idx, p.getName().getLocalPart());
        }
        return dataBinding.createWrapperHelper(wrapperClass, partNames, elTypeNames, partClasses);
    }

    private void ensureSize(List<?> lst, int idx) {
        while (idx >= lst.size()) {
            lst.add(null);
        }
    }
}

