/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.cxf.message.Message;

public class MaskSensitiveHelper {
    private static final String ELEMENT_NAME_TEMPLATE = "-ELEMENT_NAME-";
    private static final String MATCH_PATTERN_XML_TEMPLATE = "(<-ELEMENT_NAME-.*>)(.*?)(</-ELEMENT_NAME->)";
    private static final String REPLACEMENT_XML_TEMPLATE = "$1XXX$3";
    private static final String MATCH_PATTERN_JSON_TEMPLATE = "\"-ELEMENT_NAME-\"[ \\t]*:[ \\t]*\"(.*?)\"";
    private static final String REPLACEMENT_JSON_TEMPLATE = "\"-ELEMENT_NAME-\": \"XXX\"";
    private static final String MASKED_HEADER_VALUE = "XXX";
    private static final String XML_CONTENT = "xml";
    private static final String HTML_CONTENT = "html";
    private static final String JSON_CONTENT = "json";
    private final Set<ReplacementPair> replacementsXML = new HashSet<ReplacementPair>();
    private final Set<ReplacementPair> replacementsJSON = new HashSet<ReplacementPair>();

    public void addSensitiveElementNames(Set<String> inSensitiveElementNames) {
        for (String sensitiveName : inSensitiveElementNames) {
            this.addReplacementPair(MATCH_PATTERN_XML_TEMPLATE, REPLACEMENT_XML_TEMPLATE, sensitiveName, this.replacementsXML);
            this.addReplacementPair(MATCH_PATTERN_JSON_TEMPLATE, REPLACEMENT_JSON_TEMPLATE, sensitiveName, this.replacementsJSON);
        }
    }

    private void addReplacementPair(String matchPatternTemplate, String replacementTemplate, String sensitiveName, Set<ReplacementPair> replacements) {
        String matchPatternXML = matchPatternTemplate.replaceAll(ELEMENT_NAME_TEMPLATE, sensitiveName);
        String replacementXML = replacementTemplate.replaceAll(ELEMENT_NAME_TEMPLATE, sensitiveName);
        replacements.add(new ReplacementPair(matchPatternXML, replacementXML));
    }

    public String maskSensitiveElements(Message message, String originalLogString) {
        if (this.replacementsXML.isEmpty() && this.replacementsJSON.isEmpty() || originalLogString == null || message == null) {
            return originalLogString;
        }
        String contentType = (String)message.get((Object)"Content-Type");
        if (contentType == null) {
            return originalLogString;
        }
        String lowerCaseContentType = contentType.toLowerCase();
        if (lowerCaseContentType.contains(XML_CONTENT) || lowerCaseContentType.contains(HTML_CONTENT)) {
            return this.applyMasks(originalLogString, this.replacementsXML);
        }
        if (lowerCaseContentType.contains(JSON_CONTENT)) {
            return this.applyMasks(originalLogString, this.replacementsJSON);
        }
        return originalLogString;
    }

    public void maskHeaders(Map<String, String> headerMap, Set<String> sensitiveHeaderNames) {
        sensitiveHeaderNames.stream().forEach(h -> headerMap.computeIfPresent((String)h, (key, value) -> MASKED_HEADER_VALUE));
    }

    private String applyMasks(String originalLogString, Set<ReplacementPair> replacementPairs) {
        String resultString = originalLogString;
        for (ReplacementPair replacementPair : replacementPairs) {
            resultString = replacementPair.matchPattern.matcher(resultString).replaceAll(replacementPair.replacement);
        }
        return resultString;
    }

    private static class ReplacementPair {
        private final Pattern matchPattern;
        private final String replacement;

        ReplacementPair(String matchPattern, String replacement) {
            this.matchPattern = Pattern.compile(matchPattern);
            this.replacement = replacement;
        }
    }
}

