/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.staxutils.PrettyPrintXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyLoggingFilter
implements LogEventSender {
    private static final Logger LOG = LoggerFactory.getLogger(PrettyLoggingFilter.class);
    private LogEventSender next;
    private boolean prettyLogging;

    public PrettyLoggingFilter(LogEventSender next) {
        this.next = next;
        this.prettyLogging = false;
    }

    @Override
    public void send(LogEvent event) {
        if (this.shouldPrettyPrint(event)) {
            event.setPayload(this.getPrettyMessage(event.getPayload(), event.getEncoding()));
        }
        this.next.send(event);
    }

    private boolean shouldPrettyPrint(LogEvent event) {
        String contentType = event.getContentType();
        return this.prettyLogging && contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && event.getPayload().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrettyMessage(String message, String encoding) {
        StringWriter swriter = new StringWriter();
        try {
            XMLStreamWriter xwriter = StaxUtils.createXMLStreamWriter((Writer)swriter);
            xwriter = new PrettyPrintXMLStreamWriter(xwriter, 2);
            encoding = encoding == null ? "UTF-8" : encoding;
            ByteArrayInputStream in = new ByteArrayInputStream(message.getBytes(encoding));
            try {
                StaxUtils.copy((Source)new StreamSource(in), (XMLStreamWriter)xwriter);
            }
            catch (XMLStreamException xse) {
            }
            finally {
                try {
                    xwriter.flush();
                    xwriter.close();
                }
                catch (XMLStreamException xse2) {}
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            LOG.debug("Error while pretty printing cxf message, returning what we got till now.", (Throwable)e);
        }
        return swriter.toString();
    }

    public void setNext(LogEventSender next) {
        this.next = next;
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.prettyLogging = prettyLogging;
    }
}

