/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.javatowadl;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.util.DocTrees;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public final class DumpJavaDoc
implements Doclet {
    private String dumpFileName;
    private Reporter reporter;

    @Override
    public void init(Locale locale, Reporter r) {
        this.reporter = r;
    }

    @Override
    public String getName() {
        return "DumpJavaDoc";
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        Elements utils = docEnv.getElementUtils();
        DocTrees docTrees = docEnv.getDocTrees();
        try (OutputStream os = Files.newOutputStream(Paths.get(this.dumpFileName, new String[0]), new OpenOption[0]);){
            Properties javaDocMap = new Properties();
            for (Element element : docEnv.getIncludedElements()) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement classDoc = (TypeElement)element;
                DocCommentTree classCommentTree = docTrees.getDocCommentTree(classDoc);
                if (classCommentTree != null) {
                    javaDocMap.put(classDoc.toString(), this.getAllComments(classCommentTree.getFullBody()));
                }
                for (Element element2 : classDoc.getEnclosedElements()) {
                    if (!element2.getModifiers().contains((Object)Modifier.PUBLIC) || element2.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement method = (ExecutableElement)element2;
                    DocCommentTree methodCommentTree = docTrees.getDocCommentTree(method);
                    String qualifiedName = String.valueOf(utils.getBinaryName(classDoc)) + "." + String.valueOf(method.getSimpleName());
                    if (methodCommentTree == null) {
                        javaDocMap.put(qualifiedName, "");
                        continue;
                    }
                    javaDocMap.put(qualifiedName, this.getAllComments(methodCommentTree.getFullBody()));
                    for (DocTree docTree : methodCommentTree.getBlockTags()) {
                        ParamTree paramTree;
                        int index;
                        if (docTree.getKind() == DocTree.Kind.RETURN) {
                            ReturnTree returnTree = (ReturnTree)docTree;
                            javaDocMap.put(qualifiedName + ".returnCommentTag", this.getAllComments(returnTree.getDescription()));
                            continue;
                        }
                        if (docTree.getKind() != DocTree.Kind.PARAM || (index = this.getParamIndex(method, paramTree = (ParamTree)docTree)) < 0) continue;
                        javaDocMap.put(qualifiedName + ".paramCommentTag." + index, this.getAllComments(paramTree.getDescription()));
                    }
                }
            }
            javaDocMap.store(os, "");
            os.flush();
        }
        catch (IOException ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        return true;
    }

    private int getParamIndex(ExecutableElement method, ParamTree paramTree) {
        List<? extends VariableElement> parameters = method.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            if (!paramTree.getName().getName().contentEquals(parameters.get(i).getSimpleName())) continue;
            return i;
        }
        return -1;
    }

    private String getAllComments(Collection<? extends DocTree> comments) {
        return comments.stream().map(Object::toString).collect(Collectors.joining());
    }

    public Set<Doclet.Option> getSupportedOptions() {
        return Collections.singleton(new DumpJavaDocFileOption());
    }

    private final class DumpJavaDocFileOption
    implements Doclet.Option {
        private DumpJavaDocFileOption() {
        }

        @Override
        public int getArgumentCount() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Specify the file to dump Javadoc for later use";
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return Collections.singletonList("-dumpJavaDocFile");
        }

        @Override
        public String getParameters() {
            return "theFileToDumpJavaDocForLaterUse";
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            DumpJavaDoc.this.dumpFileName = arguments.get(0);
            return true;
        }
    }
}

