/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer.jaxrs;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.net.URI;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tracing.micrometer.jaxrs.JaxrsObservationDocumentation;
import org.jspecify.annotations.Nullable;

class AbstractJaxrsObservationConvention {
    AbstractJaxrsObservationConvention() {
    }

    KeyValues lowCardinalityKeyValues(String method, URI uri, @Nullable Integer responseStatus) {
        KeyValue requestMethod = JaxrsObservationDocumentation.CommonLowCardinalityKeys.HTTP_REQUEST_METHOD.withValue(method);
        KeyValue network = JaxrsObservationDocumentation.CommonLowCardinalityKeys.NETWORK_PROTOCOL_NAME.withValue("http");
        KeyValue serverAddress = JaxrsObservationDocumentation.CommonLowCardinalityKeys.SERVER_ADRESS.withValue(uri.getHost());
        KeyValue serverPort = JaxrsObservationDocumentation.CommonLowCardinalityKeys.SERVER_PORT.withValue(String.valueOf(uri.getPort()));
        KeyValue urlScheme = JaxrsObservationDocumentation.CommonLowCardinalityKeys.URL_SCHEME.withValue(String.valueOf(uri.getScheme()));
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{requestMethod, network, serverAddress, serverPort, urlScheme});
        if (responseStatus != null) {
            keyValues = keyValues.and(new KeyValue[]{JaxrsObservationDocumentation.CommonLowCardinalityKeys.HTTP_RESPONSE_STATUS_CODE.withValue(String.valueOf(responseStatus))});
        }
        return keyValues;
    }

    KeyValues highCardinalityKeyValues(int requestLength, @Nullable Integer responseLength, @Nullable String userAgentHeader) {
        KeyValue requestBody;
        KeyValues keyValues = KeyValues.empty();
        KeyValue keyValue = requestBody = requestLength != -1 ? JaxrsObservationDocumentation.CommonHighCardinalityKeys.REQUEST_BODY_SIZE.withValue(String.valueOf(requestLength)) : null;
        if (requestBody != null) {
            keyValues = keyValues.and(new KeyValue[]{requestBody});
        }
        KeyValue responseBody = null;
        if (responseLength != null && responseLength != -1) {
            responseBody = JaxrsObservationDocumentation.CommonHighCardinalityKeys.RESPONSE_BODY_SIZE.withValue(String.valueOf(responseLength));
        }
        if (responseBody != null) {
            keyValues = keyValues.and(new KeyValue[]{responseBody});
        }
        if (!StringUtils.isEmpty((String)userAgentHeader)) {
            keyValues = keyValues.and(new KeyValue[]{JaxrsObservationDocumentation.CommonHighCardinalityKeys.USER_AGENT_ORIGINAL.withValue(userAgentHeader)});
        }
        return keyValues;
    }
}

