/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.cxf.tracing.micrometer.ObservationScope;

public class ObservationTracerContext
implements TracerContext {
    private final ObservationRegistry observationRegistry;
    private final Observation continuationObservation;

    public ObservationTracerContext(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public ObservationTracerContext(ObservationRegistry observationRegistry, Observation continuationObservation) {
        this.observationRegistry = observationRegistry;
        this.continuationObservation = continuationObservation;
    }

    public ObservationScope startSpan(String description) {
        return new ObservationScope(Observation.start((String)description, (ObservationRegistry)this.observationRegistry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        Observation.Scope scope = null;
        if (this.observationRegistry.getCurrentObservation() == null && this.continuationObservation != null) {
            scope = this.continuationObservation.openScope();
        }
        try {
            Object object = traceable.call((TracerContext)new ObservationTracerContext(this.observationRegistry));
            return (T)object;
        }
        finally {
            if (this.continuationObservation != null && scope != null) {
                scope.close();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new ObservationTracerContext(ObservationTracerContext.this.observationRegistry));
            }
        };
        Observation parent = this.observationRegistry.getCurrentObservation();
        return () -> {
            try (ObservationScope span = this.newOrChildSpan(description, parent);){
                Object v = callable.call();
                return v;
            }
        };
    }

    public void annotate(String key, String value) {
        Observation current = this.observationRegistry.getCurrentObservation();
        if (current != null) {
            current.highCardinalityKeyValue(key, value);
        }
    }

    public void timeline(String message) {
        Observation current = this.observationRegistry.getCurrentObservation();
        if (current != null) {
            current.event(Observation.Event.of((String)message));
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ObservationRegistry.class.equals(clazz)) {
            return (T)this.observationRegistry;
        }
        throw new IllegalArgumentException("The class is '" + String.valueOf(clazz) + "'not supported and cannot be unwrapped");
    }

    private ObservationScope newOrChildSpan(String description, Observation parent) {
        if (parent == null) {
            return new ObservationScope(Observation.start((String)description, (ObservationRegistry)this.observationRegistry));
        }
        return new ObservationScope(Observation.createNotStarted((String)description, (ObservationRegistry)this.observationRegistry).parentObservation(parent).start());
    }
}

