/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.micrometer.AbstractObservationClientInterceptor;
import org.apache.cxf.tracing.micrometer.CxfObservationDocumentation;
import org.apache.cxf.tracing.micrometer.DefaultMessageOutObservationConvention;
import org.apache.cxf.tracing.micrometer.MessageOutContext;
import org.apache.cxf.tracing.micrometer.MessageOutObservationConvention;
import org.apache.cxf.tracing.micrometer.ObservationScope;
import org.jspecify.annotations.Nullable;

public class ObservationClientStartInterceptor
extends AbstractObservationClientInterceptor {
    final MessageOutObservationConvention convention;

    public ObservationClientStartInterceptor(ObservationRegistry observationRegistry) {
        this("pre-stream", observationRegistry, null);
    }

    public ObservationClientStartInterceptor(ObservationRegistry observationRegistry, @Nullable MessageOutObservationConvention convention) {
        this("pre-stream", observationRegistry, convention);
    }

    public ObservationClientStartInterceptor(String phase, ObservationRegistry observationRegistry, @Nullable MessageOutObservationConvention convention) {
        super(phase, observationRegistry);
        this.convention = convention;
    }

    public void handleMessage(Message message) throws Fault {
        MessageOutContext messageOutContext = new MessageOutContext(message);
        Observation observation = CxfObservationDocumentation.OUT_OBSERVATION.start(this.convention, DefaultMessageOutObservationConvention.INSTANCE, () -> messageOutContext, this.getObservationRegistry());
        AbstractTracingProvider.TraceScopeHolder<ObservationScope> holder = super.startScopedObservation(observation);
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.client.micrometer.observation", holder);
        }
    }

    @Override
    public void handleFault(Message message) {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)message.getExchange().get((Object)"org.apache.cxf.tracing.client.micrometer.observation");
        Exception ex = (Exception)message.getContent(Exception.class);
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<ObservationScope>)holder, ex, observation -> {
            MessageOutContext context = (MessageOutContext)observation.getContext();
            context.setResponse(message);
        });
    }
}

