/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.io.Serializable;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.connector.CXFConnectionFactory;
import org.apache.cxf.connector.CXFConnectionParam;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFConnectionRequestInfo;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;

public class ConnectionFactoryImpl
implements CXFConnectionFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = 3664687493256918163L;
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ConnectionFactoryImpl.class);
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionManager connectionManager;
    private Reference reference;

    public ConnectionFactoryImpl(ManagedConnectionFactory aMCF, ConnectionManager aCM) {
        this.managedConnectionFactory = aMCF;
        this.connectionManager = aCM;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    public Object getBus() {
        return ((ManagedConnectionFactoryImpl)this.managedConnectionFactory).getBus();
    }

    public Object getConnection(CXFConnectionParam param) throws ResourceException {
        if (param.getInterface() == null) {
            throw new ResourceAdapterInternalException(new Message("INTERFACE_IS_NULL", BUNDLE, new Object[0]).toString());
        }
        if (!param.getInterface().isInterface()) {
            throw new ResourceAdapterInternalException(new Message("IS_NOT_AN_INTERFACE", BUNDLE, new Object[]{param.getInterface()}).toString());
        }
        CXFConnectionRequestInfo reqInfo = (CXFConnectionRequestInfo)param;
        if (this.connectionManager == null) {
            ManagedConnection connection = this.managedConnectionFactory.createManagedConnection(null, (ConnectionRequestInfo)reqInfo);
            return connection.getConnection(null, (ConnectionRequestInfo)reqInfo);
        }
        return this.connectionManager.allocateConnection(this.managedConnectionFactory, (ConnectionRequestInfo)reqInfo);
    }
}

