/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import org.apache.cxf.cdi.ContextResolved;

final class DelegateContextAnnotatedType<X>
implements AnnotatedType<X> {
    private static final Inject INJECT = new InjectLiteral();
    private static final ContextResolved CONTEXT_RESOLVED = ContextResolved.LITERAL;
    private final AnnotatedType<X> original;
    private final Set<AnnotatedField<? super X>> replacedFields;

    DelegateContextAnnotatedType(AnnotatedType<X> original) {
        this.original = original;
        this.replacedFields = this.replaceFields(original);
    }

    private Set<AnnotatedField<? super X>> replaceFields(AnnotatedType<? super X> delegate) {
        return delegate.getFields().stream().map(this::wrap).collect(Collectors.toSet());
    }

    Set<Type> getContextFieldTypes() {
        return this.replacedFields.stream().filter(f -> f.isAnnotationPresent(Context.class) || f.isAnnotationPresent(ContextResolved.class)).map(f -> f.getJavaMember().getAnnotatedType().getType()).collect(Collectors.toSet());
    }

    public Class<X> getJavaClass() {
        return this.original.getJavaClass();
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.original.getConstructors();
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.original.getMethods();
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.replacedFields;
    }

    public Type getBaseType() {
        return this.original.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.original.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.original.getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        return this.original.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.original.isAnnotationPresent(annotationType);
    }

    private AnnotatedField<? super X> wrap(AnnotatedField<? super X> af) {
        if (af.isAnnotationPresent(Context.class)) {
            return new DelegateAnnotatedField(af);
        }
        return af;
    }

    private static final class InjectLiteral
    extends AnnotationLiteral<Inject>
    implements Inject {
        private static final long serialVersionUID = 1L;

        private InjectLiteral() {
        }
    }

    private final class DelegateAnnotatedField<Y>
    implements AnnotatedField<Y> {
        private final AnnotatedField<Y> original;
        private final Set<Annotation> annotationSet;

        private DelegateAnnotatedField(AnnotatedField<Y> delegate) {
            this.original = delegate;
            this.annotationSet = this.processAnnotations(delegate.getAnnotations());
        }

        private Set<Annotation> processAnnotations(Set<Annotation> annotations) {
            LinkedHashSet<Object> resultAnnotations = new LinkedHashSet<Object>();
            for (Annotation a : annotations) {
                if (a instanceof Context) {
                    resultAnnotations.add(INJECT);
                    resultAnnotations.add(CONTEXT_RESOLVED);
                }
                resultAnnotations.add(a);
            }
            return Collections.unmodifiableSet(resultAnnotations);
        }

        public Field getJavaMember() {
            return this.original.getJavaMember();
        }

        public boolean isStatic() {
            return this.original.isStatic();
        }

        public AnnotatedType<Y> getDeclaringType() {
            return this.original.getDeclaringType();
        }

        public Type getBaseType() {
            return this.original.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.original.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation a : this.annotationSet) {
                if (annotationType != a.annotationType()) continue;
                return (T)a;
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotationSet;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }
}

