/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingNamespaceContext
implements NamespaceContext {
    private List<Map<String, String>> prefixes;
    private NamespaceContext nc;
    private Map<String, String> nsMap;

    public DelegatingNamespaceContext(NamespaceContext nc, Map<String, String> nsMap) {
        this.nc = nc;
        this.nsMap = nsMap;
        this.prefixes = new LinkedList<Map<String, String>>();
        this.prefixes.add(new HashMap());
    }

    public void down() {
        HashMap<String, String> pm = new HashMap<String, String>();
        if (this.prefixes.size() > 0) {
            pm.putAll(this.prefixes.get(0));
        }
        this.prefixes.add(0, pm);
    }

    public void up() {
        this.prefixes.remove(0);
    }

    public void addPrefix(String prefix, String namespace) {
        this.prefixes.get(0).put(namespace, prefix);
    }

    public String findUniquePrefix(String namespace) {
        if (namespace.length() == 0) {
            return null;
        }
        String existingPrefix = this.prefixes.get(0).get(namespace);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        int i = 0;
        while (this.prefixes.get(0).containsValue("ps" + ++i)) {
        }
        String prefix = "ps" + i;
        this.addPrefix(prefix, namespace);
        return prefix;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        for (Map.Entry<String, String> entry : this.prefixes.get(0).entrySet()) {
            if (!entry.getValue().equals(prefix)) continue;
            return entry.getKey();
        }
        String ns = this.nc.getNamespaceURI(prefix);
        this.addPrefix(prefix, ns);
        return ns;
    }

    @Override
    public String getPrefix(String ns) {
        String actualNs;
        if (ns.length() == 0) {
            return null;
        }
        String value = this.nsMap.get(ns);
        if (value != null && value.length() == 0) {
            return null;
        }
        String string = actualNs = value == null ? ns : value;
        if (this.prefixes.get(0).containsKey(actualNs)) {
            return this.prefixes.get(0).get(actualNs);
        }
        String prefix = this.nc.getPrefix(actualNs);
        this.addPrefix(prefix, actualNs);
        return prefix;
    }

    public Iterator getPrefixes(String ns) {
        return this.nc.getPrefixes(ns);
    }
}

