/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.cxf.common.util.StreamPrinter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    private long maxMemory = Runtime.getRuntime().maxMemory();
    private boolean verbose;
    private String target;
    private String outputDir;
    private String classPath;
    private String encoding;
    private boolean forceFork = Boolean.getBoolean(Compiler.class.getName() + "-fork");

    public void setMaxMemory(long l) {
        this.maxMemory = l;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setTarget(String s) {
        this.target = s;
    }

    public void setOutputDir(File s) {
        this.outputDir = s != null ? s.getAbsolutePath().replace(File.pathSeparatorChar, '/') : null;
    }

    public void setOutputDir(String s) {
        this.outputDir = s.replace(File.pathSeparatorChar, '/');
    }

    public void setClassPath(String s) {
        this.classPath = StringUtils.isEmpty(s) ? null : s;
    }

    private void addArgs(List<String> list) {
        if (this.verbose) {
            list.add("-verbose");
        }
        if (!StringUtils.isEmpty(this.encoding)) {
            list.add("-encoding");
            list.add(this.encoding);
        }
        if (!StringUtils.isEmpty(this.target)) {
            list.add("-target");
            list.add(this.target);
            list.add("-source");
            list.add(this.target);
        }
        if (!StringUtils.isEmpty(this.outputDir)) {
            list.add("-d");
            list.add(this.outputDir);
        }
        if (StringUtils.isEmpty(this.classPath)) {
            boolean classpathSetted;
            String javaClasspath = SystemPropertyAction.getProperty("java.class.path");
            boolean bl = classpathSetted = javaClasspath != null;
            if (!classpathSetted) {
                File f = new File(this.getClass().getClassLoader().getResource(".").getFile());
                if ((f = new File(f, "../lib")).exists() && f.isDirectory()) {
                    list.add("-extdirs");
                    list.add(f.toString());
                }
            } else {
                list.add("-classpath");
                list.add(javaClasspath);
            }
        } else {
            list.add("-classpath");
            list.add(this.classPath);
        }
    }

    public boolean compileFiles(File[] files) {
        ArrayList<String> f = new ArrayList<String>(files.length);
        for (File file : files) {
            f.add(file.getAbsolutePath());
        }
        return this.compileFiles(f.toArray(new String[files.length]));
    }

    public boolean compileFiles(List<File> files) {
        ArrayList<String> f = new ArrayList<String>(files.size());
        for (File file : files) {
            f.add(file.getAbsolutePath());
        }
        return this.compileFiles(f.toArray(new String[files.size()]));
    }

    public boolean compileFiles(String[] files) {
        String endorsed = SystemPropertyAction.getProperty("java.endorsed.dirs");
        if (!this.forceFork) {
            try {
                Class.forName("javax.tools.JavaCompiler");
                return this.useJava6Compiler(files);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        String fsep = File.separator;
        String javacstr = "javac";
        String platformjavacname = "javac";
        if (SystemPropertyAction.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            platformjavacname = "javac.exe";
        }
        if (new File(SystemPropertyAction.getProperty("java.home") + fsep + platformjavacname).exists()) {
            javacstr = SystemPropertyAction.getProperty("java.home") + fsep + platformjavacname;
        } else if (new File(SystemPropertyAction.getProperty("java.home") + fsep + ".." + fsep + "bin" + fsep + platformjavacname).exists()) {
            javacstr = SystemPropertyAction.getProperty("java.home") + fsep + ".." + fsep + "bin" + fsep + platformjavacname;
        }
        list.add(javacstr);
        if (!StringUtils.isEmpty(endorsed)) {
            list.add("-endorseddirs");
            list.add(endorsed);
        }
        list.add("-J-Xmx" + this.maxMemory);
        this.addArgs(list);
        int idx = list.size();
        list.addAll(Arrays.asList(files));
        return this.internalCompile(list.toArray(new String[list.size()]), idx);
    }

    private boolean useJava6Compiler(String[] files) throws Exception {
        Object compiler = Class.forName("javax.tools.ToolProvider").getMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]);
        Object fileManager = compiler.getClass().getMethod("getStandardFileManager", Class.forName("javax.tools.DiagnosticListener"), Locale.class, Charset.class).invoke(compiler, null, null, null);
        Object fileList = fileManager.getClass().getMethod("getJavaFileObjectsFromStrings", Iterable.class).invoke(fileManager, Arrays.asList(files));
        ArrayList<String> args = new ArrayList<String>();
        this.addArgs(args);
        Object task = compiler.getClass().getMethod("getTask", Writer.class, Class.forName("javax.tools.JavaFileManager"), Class.forName("javax.tools.DiagnosticListener"), Iterable.class, Iterable.class, Iterable.class).invoke(compiler, null, fileManager, null, args, null, fileList);
        Boolean ret = (Boolean)task.getClass().getMethod("call", new Class[0]).invoke(task, new Object[0]);
        fileManager.getClass().getMethod("close", new Class[0]).invoke(fileManager, new Object[0]);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean internalCompile(String[] args, int sourceFileIndex) {
        File tmpFile;
        block17: {
            boolean infoStreamPrinter2;
            Process p = null;
            String[] cmdArray = null;
            tmpFile = null;
            try {
                try {
                    if (this.isLongCommandLines(args) && sourceFileIndex >= 0) {
                        PrintWriter out = null;
                        tmpFile = FileUtils.createTempFile("cxf-compiler", null);
                        out = new PrintWriter(new FileWriter(tmpFile));
                        for (int i = sourceFileIndex; i < args.length; ++i) {
                            if (args[i].indexOf(" ") > -1) {
                                args[i] = args[i].replace(File.separatorChar, '/');
                                if (args[i].indexOf("package-info.java") > -1 && SystemPropertyAction.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                                    out.println("\"" + args[i].replaceAll("/", "\\\\\\\\") + "\"");
                                    continue;
                                }
                                out.println("\"" + args[i] + "\"");
                                continue;
                            }
                            out.println(args[i]);
                        }
                        out.flush();
                        out.close();
                        cmdArray = new String[sourceFileIndex + 1];
                        System.arraycopy(args, 0, cmdArray, 0, sourceFileIndex);
                        cmdArray[sourceFileIndex] = "@" + tmpFile;
                    } else {
                        cmdArray = new String[args.length];
                        System.arraycopy(args, 0, cmdArray, 0, args.length);
                    }
                    if (SystemPropertyAction.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                        for (int i = 0; i < cmdArray.length; ++i) {
                            if (cmdArray[i].indexOf("package-info") != -1) continue;
                            cmdArray[i] = cmdArray[i].replace('\\', '/');
                        }
                    }
                    if ((p = Runtime.getRuntime().exec(cmdArray)).getErrorStream() != null) {
                        StreamPrinter errorStreamPrinter = new StreamPrinter(p.getErrorStream(), "", System.out);
                        errorStreamPrinter.start();
                    }
                    if (p.getInputStream() != null) {
                        StreamPrinter infoStreamPrinter2 = new StreamPrinter(p.getInputStream(), "[INFO]", System.out);
                        infoStreamPrinter2.start();
                    }
                    if (p == null) break block17;
                    infoStreamPrinter2 = p.waitFor() == 0;
                    Object var9_15 = null;
                    if (tmpFile == null) return infoStreamPrinter2;
                }
                catch (SecurityException e) {
                    System.err.println("[ERROR] SecurityException during exec() of compiler \"" + args[0] + "\".");
                    Object var9_17 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                catch (InterruptedException e) {
                    Object var9_18 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                catch (IOException e) {
                    System.err.print("[ERROR] IOException during exec() of compiler \"" + args[0] + "\"");
                    System.err.println(". Check your path environment variable.");
                    Object var9_19 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                if (!tmpFile.exists()) return infoStreamPrinter2;
            }
            catch (Throwable throwable) {
                Object var9_20 = null;
                if (tmpFile == null) throw throwable;
                if (!tmpFile.exists()) throw throwable;
                FileUtils.delete(tmpFile);
                throw throwable;
            }
            FileUtils.delete(tmpFile);
            return infoStreamPrinter2;
        }
        Object var9_16 = null;
        if (tmpFile == null) return false;
        if (!tmpFile.exists()) return false;
        FileUtils.delete(tmpFile);
        return false;
    }

    private boolean isLongCommandLines(String[] args) {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            strBuffer.append(args[i]);
        }
        return strBuffer.toString().length() > 4096;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

