/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.CodegenUtils;
import org.apache.cxf.maven_plugin.WsdlOption;
import org.apache.cxf.maven_plugin.WsdlOptionLoader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaMojo
extends AbstractMojo {
    File testSourceRoot;
    File sourceRoot;
    String classesDirectory;
    MavenProject project;
    WsdlOption[] wsdlOptions;
    File wsdlRoot;
    File testWsdlRoot;
    boolean useCompileClasspath;
    String[] includes;
    String[] excludes;

    private List<WsdlOption> getWsdlOptionsFromDir(File root, File output) throws MojoExecutionException {
        ArrayList<WsdlOption> options = new ArrayList<WsdlOption>();
        for (WsdlOption o : new WsdlOptionLoader().load(root, this.includes, this.excludes)) {
            if (o.getOutputDir() == null) {
                o.setOutputDir(output);
            }
            if (options.contains(o)) continue;
            options.add(o);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        ArrayList<WsdlOption> options = new ArrayList<WsdlOption>();
        if (this.wsdlRoot != null && this.wsdlRoot.exists()) {
            options.addAll(this.getWsdlOptionsFromDir(this.wsdlRoot, this.sourceRoot));
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists()) {
            options.addAll(this.getWsdlOptionsFromDir(this.testWsdlRoot, this.testSourceRoot));
        }
        if (this.wsdlOptions != null) {
            File outputDirFile = this.testSourceRoot == null ? this.sourceRoot : this.testSourceRoot;
            for (WsdlOption o : this.wsdlOptions) {
                if (o.getOutputDir() == null) {
                    o.setOutputDir(outputDirFile);
                }
                options.add(o);
            }
        }
        this.wsdlOptions = options.toArray(new WsdlOption[options.size()]);
        if (this.wsdlOptions.length == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringBuffer buf = new StringBuffer();
        try {
            urlList.add(classesDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        buf.append(classesDir.getAbsolutePath());
        buf.append(File.pathSeparatorChar);
        List artifacts = this.useCompileClasspath ? this.project.getCompileArtifacts() : this.project.getTestArtifacts();
        for (Artifact a : CastUtils.cast((List)artifacts, Artifact.class)) {
            try {
                if (a.getFile() == null || !a.getFile().exists()) continue;
                urlList.add(a.getFile().toURI().toURL());
                buf.append(a.getFile().getAbsolutePath());
                buf.append(File.pathSeparatorChar);
            }
            catch (MalformedURLException e) {}
        }
        ClassLoader origContext = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), origContext);
        String newCp = buf.toString();
        HashMap<Object, Object> origProps = new HashMap<Object, Object>(System.getProperties());
        String cp = System.getProperty("java.class.path");
        long timestamp = CodegenUtils.getCodegenTimestamp();
        boolean result = true;
        try {
            Thread.currentThread().setContextClassLoader(loader);
            System.setProperty("java.class.path", newCp);
            for (WsdlOption o : this.wsdlOptions) {
                this.processWsdl(o, timestamp);
                File[] dirs = o.getDeleteDirs();
                if (dirs == null) continue;
                for (int idx = 0; idx < dirs.length; ++idx) {
                    result = result && this.deleteDir(dirs[idx]);
                }
            }
            Object var21_23 = null;
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            Bus bus = BusFactory.getDefaultBus((boolean)false);
            if (bus != null) {
                bus.shutdown(true);
            }
            Thread.currentThread().setContextClassLoader(origContext);
            System.setProperty("java.class.path", cp);
            HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
            for (Object o : newProps.keySet()) {
                if (origProps.containsKey(o)) continue;
                System.clearProperty(o.toString());
            }
            System.getProperties().putAll((Map<?, ?>)origProps);
            throw throwable;
        }
        Bus bus = BusFactory.getDefaultBus((boolean)false);
        if (bus != null) {
            bus.shutdown(true);
        }
        Thread.currentThread().setContextClassLoader(origContext);
        System.setProperty("java.class.path", cp);
        HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
        for (Object o : newProps.keySet()) {
            if (origProps.containsKey(o)) continue;
            System.clearProperty(o.toString());
        }
        {
        }
        System.getProperties().putAll((Map<?, ?>)origProps);
        if (this.project != null && this.sourceRoot != null && this.sourceRoot.exists()) {
            this.project.addCompileSourceRoot(this.sourceRoot.getAbsolutePath());
        }
        if (this.project != null && this.testSourceRoot != null && this.testSourceRoot.exists()) {
            this.project.addTestCompileSourceRoot(this.testSourceRoot.getAbsolutePath());
        }
        System.gc();
    }

    private void processWsdl(WsdlOption wsdlOption, long cgtimestamp) throws MojoExecutionException {
        boolean doWork;
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        File file = new File(wsdlOption.getWsdl());
        File doneFile = new File(outputDirFile, "." + file.getName().replace('?', '_').replace('&', '_') + ".DONE");
        boolean bl = doWork = cgtimestamp > doneFile.lastModified();
        if (!doneFile.exists()) {
            doWork = true;
        } else if (file.lastModified() > doneFile.lastModified()) {
            doWork = true;
        } else if (this.isDefServiceName(wsdlOption)) {
            doWork = true;
        } else {
            File[] files = wsdlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        if (doWork) {
            doneFile.delete();
            ArrayList<String> list = new ArrayList<String>();
            if (wsdlOption.getPackagenames() != null) {
                Iterator<String> it = wsdlOption.getPackagenames().iterator();
                while (it.hasNext()) {
                    list.add("-p");
                    list.add(it.next().toString());
                }
            }
            list.add("-d");
            list.add(outputDirFile.toString());
            if (wsdlOption.getExtraargs() != null) {
                Iterator<String> it = wsdlOption.getExtraargs().iterator();
                while (it.hasNext()) {
                    list.add(it.next().toString());
                }
            }
            list.add(wsdlOption.getWsdl());
            try {
                new WSDLToJava(list.toArray(new String[list.size()])).run(new ToolContext());
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                this.getLog().debug(e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    private boolean isDefServiceName(WsdlOption wsdlOption) {
        List<String> args = wsdlOption.extraargs;
        if (args == null) {
            return false;
        }
        for (int i = 0; i < args.size(); ++i) {
            if (!"-sn".equalsIgnoreCase(args.get(i))) continue;
            return true;
        }
        return false;
    }
}

