/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.processor.UsernameTokenProcessor;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.wss4j.policy.SP13Constants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Element;

public class UsernameTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement(el);
        while (child != null) {
            if ("UsernameToken".equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                try {
                    UsernameTokenPrincipal princ = this.getPrincipal(child, message);
                    if (princ != null) {
                        ArrayList<WSSecurityEngineResult> v = new ArrayList<WSSecurityEngineResult>();
                        int action = 1;
                        if (princ.getPassword() == null) {
                            action = 8192;
                        }
                        v.add(0, new WSSecurityEngineResult(action, (Principal)princ, null, null, null));
                        List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                        if (results == null) {
                            results = new ArrayList();
                            message.put("RECV_RESULTS", (Object)results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, v);
                        results.add(0, rResult);
                        this.assertTokens(message, princ, false);
                        message.put("wss4j.principal.result", (Object)princ);
                        SecurityContext sc = message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            String nonce = null;
                            if (princ.getNonce() != null) {
                                nonce = Base64.encode((byte[])princ.getNonce());
                            }
                            Subject subject = this.createSubject(princ.getName(), princ.getPassword(), princ.isPasswordDigest(), nonce, princ.getCreatedTime());
                            message.put(SecurityContext.class, this.createSecurityContext((Principal)princ, subject));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
                catch (Base64DecodingException ex) {
                    throw new Fault(ex);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    protected UsernameTokenPrincipal getPrincipal(Element tokenElement, final SoapMessage message) throws WSSecurityException, Base64DecodingException {
        boolean bspCompliant = this.isWsiBSPCompliant(message);
        boolean utWithCallbacks = MessageUtils.getContextualBoolean(message, "ws-security.validate.token", true);
        boolean allowNoPassword = this.isAllowNoPassword(message.get(AssertionInfoMap.class));
        if (utWithCallbacks) {
            UsernameTokenProcessor p = new UsernameTokenProcessor();
            WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
            RequestData data = new RequestData(){

                public CallbackHandler getCallbackHandler() {
                    return UsernameTokenInterceptor.this.getCallback(message);
                }

                public Validator getValidator(QName qName) throws WSSecurityException {
                    Object validator = message.getContextualProperty("ws-security.ut.validator");
                    if (validator == null) {
                        return super.getValidator(qName);
                    }
                    return (Validator)validator;
                }
            };
            ReplayCache nonceCache = WSS4JUtils.getReplayCache(message, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
            data.setNonceReplayCache(nonceCache);
            WSSConfig config = WSSConfig.getNewInstance();
            config.setAllowUsernameTokenNoPassword(allowNoPassword);
            data.setWssConfig(config);
            if (!bspCompliant) {
                data.setDisableBSPEnforcement(true);
            }
            List results = p.handleToken(tokenElement, data, wsDocInfo);
            return (UsernameTokenPrincipal)((WSSecurityEngineResult)results.get(0)).get((Object)"principal");
        }
        UsernameTokenPrincipal principal = this.parseTokenAndCreatePrincipal(tokenElement, bspCompliant);
        WSS4JTokenConverter.convertToken(message, (Principal)principal);
        return principal;
    }

    protected UsernameTokenPrincipal parseTokenAndCreatePrincipal(Element tokenElement, boolean bspCompliant) throws WSSecurityException, Base64DecodingException {
        BSPEnforcer bspEnforcer = new BSPEnforcer(!bspCompliant);
        org.apache.wss4j.dom.message.token.UsernameToken ut = new org.apache.wss4j.dom.message.token.UsernameToken(tokenElement, false, bspEnforcer);
        WSUsernameTokenPrincipalImpl principal = new WSUsernameTokenPrincipalImpl(ut.getName(), ut.isHashed());
        if (ut.getNonce() != null) {
            principal.setNonce(Base64.decode((String)ut.getNonce()));
        }
        principal.setPassword(ut.getPassword());
        principal.setCreatedTime(ut.getCreated());
        principal.setPasswordType(ut.getPasswordType());
        return principal;
    }

    protected boolean isWsiBSPCompliant(SoapMessage message) {
        String bspc = (String)message.getContextualProperty("ws-security.is-bsp-compliant");
        return !"false".equals(bspc) && !"0".equals(bspc);
    }

    private boolean isAllowNoPassword(AssertionInfoMap aim) throws WSSecurityException {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "UsernameToken");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                UsernameToken policy = (UsernameToken)ai.getAssertion();
                if (policy.getPasswordType() != UsernameToken.PasswordType.NoPassword) continue;
                return true;
            }
        }
        return false;
    }

    protected SecurityContext createSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) throws SecurityException {
        return null;
    }

    protected UsernameToken assertTokens(SoapMessage message) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        this.assertPolicy(aim, "WssUsernameToken10");
        this.assertPolicy(aim, "WssUsernameToken11");
        this.assertPolicy(aim, "HashPassword");
        this.assertPolicy(aim, "NoPassword");
        this.assertPolicy(aim, SP13Constants.NONCE);
        this.assertPolicy(aim, SP13Constants.CREATED);
        return (UsernameToken)this.assertTokens(message, "UsernameToken", true);
    }

    private UsernameToken assertTokens(SoapMessage message, UsernameTokenPrincipal princ, boolean signed) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "UsernameToken");
        UsernameToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (UsernameToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!(tok.getPasswordType() != UsernameToken.PasswordType.HashPassword || princ != null && princ.isPasswordDigest())) {
                ai.setNotAsserted("Password hashing policy not enforced");
            } else {
                this.assertPolicy(aim, "HashPassword");
            }
            if (tok.getPasswordType() != UsernameToken.PasswordType.NoPassword && this.isNonEndorsingSupportingToken(tok) && (princ == null || princ.getPassword() == null)) {
                ai.setNotAsserted("Username Token No Password supplied");
            } else {
                this.assertPolicy(aim, "NoPassword");
            }
            if (tok.isCreated() && princ.getCreatedTime() == null) {
                ai.setNotAsserted("No Created Time");
            } else {
                this.assertPolicy(aim, SP13Constants.CREATED);
            }
            if (tok.isNonce() && princ.getNonce() == null) {
                ai.setNotAsserted("No Nonce");
                continue;
            }
            this.assertPolicy(aim, SP13Constants.NONCE);
        }
        this.assertPolicy(aim, "WssUsernameToken10");
        this.assertPolicy(aim, "WssUsernameToken11");
        this.assertPolicy(aim, "SupportingTokens");
        if (signed || this.isTLSInUse(message)) {
            this.assertPolicy(aim, "SignedSupportingTokens");
        }
        return tok;
    }

    private boolean isNonEndorsingSupportingToken(UsernameToken usernameTokenPolicy) {
        AbstractSecurityAssertion supportingToken = usernameTokenPolicy.getParentAssertion();
        return !(supportingToken instanceof SupportingTokens) || !((SupportingTokens)supportingToken).isEndorsing();
    }

    @Override
    protected void addToken(SoapMessage message) {
        UsernameToken tok = this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        WSSecUsernameToken utBuilder = this.addUsernameToken(message, tok);
        if (utBuilder == null) {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "UsernameToken");
            for (AssertionInfo ai : ais) {
                if (!ai.isAsserted()) continue;
                ai.setAsserted(false);
            }
            return;
        }
        Element el = (Element)h.getObject();
        utBuilder.prepare(el.getOwnerDocument());
        el.appendChild(utBuilder.getUsernameTokenElement());
    }

    protected WSSecUsernameToken addUsernameToken(SoapMessage message, UsernameToken token) {
        String userName = (String)message.getContextualProperty("ws-security.username");
        WSSConfig wssConfig = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        if (!StringUtils.isEmpty(userName)) {
            if (token.getPasswordType() == UsernameToken.PasswordType.NoPassword) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                return utBuilder;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty(password)) {
                password = this.getPassword(userName, (AbstractToken)token, 2, message);
            }
            if (!StringUtils.isEmpty(password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                if (token.getPasswordType() == UsernameToken.PasswordType.HashPassword) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                return utBuilder;
            }
            this.policyNotAsserted((AbstractToken)token, "No username available", message);
        } else {
            this.policyNotAsserted((AbstractToken)token, "No username available", message);
        }
        return null;
    }
}

