/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.common.TrustValidator;
import org.apache.cxf.rs.security.xml.AbstractXmlSecInHandler;
import org.apache.cxf.rs.security.xml.SignatureProperties;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractXmlSigInHandler
extends AbstractXmlSecInHandler {
    private boolean removeSignature = true;
    private boolean persistSignature = true;
    private boolean keyInfoMustBeAvailable = true;
    private SignatureProperties sigProps;

    public void setRemoveSignature(boolean remove) {
        this.removeSignature = remove;
    }

    public void setPersistSignature(boolean persist) {
        this.persistSignature = persist;
    }

    protected void checkSignature(Message message) {
        Document doc = this.getDocument(message);
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        Element signatureElement = this.getSignatureElement(root);
        if (signatureElement == null) {
            this.throwFault("XML Signature is not available", null);
        }
        String cryptoKey = null;
        String propKey = null;
        if (SecurityUtils.isSignedAndEncryptedTwoWay(message)) {
            cryptoKey = "ws-security.encryption.crypto";
            propKey = "ws-security.encryption.properties";
        } else {
            cryptoKey = "ws-security.signature.crypto";
            propKey = "ws-security.signature.properties";
        }
        Crypto crypto = null;
        try {
            CryptoLoader loader = new CryptoLoader();
            crypto = loader.getCrypto(message, cryptoKey, propKey);
        }
        catch (Exception ex) {
            this.throwFault("Crypto can not be loaded", ex);
        }
        boolean valid = false;
        Reference ref = null;
        try {
            Element signedElement;
            XMLSignature signature = new XMLSignature(signatureElement, "", true);
            if (this.sigProps != null) {
                SignedInfo sInfo = signature.getSignedInfo();
                if (this.sigProps.getSignatureAlgo() != null && !this.sigProps.getSignatureAlgo().equals(sInfo.getSignatureMethodURI())) {
                    this.throwFault("Signature Algorithm is not supported", null);
                }
                if (this.sigProps.getSignatureC14nMethod() != null && !this.sigProps.getSignatureC14nMethod().equals(sInfo.getCanonicalizationMethodURI())) {
                    this.throwFault("Signature C14n Algorithm is not supported", null);
                }
            }
            if ((signedElement = this.validateReference(root, ref = this.getReference(signature))).hasAttributeNS(null, "ID")) {
                signedElement.setIdAttributeNS(null, "ID", true);
            }
            if (signedElement.hasAttributeNS(null, "Id")) {
                signedElement.setIdAttributeNS(null, "Id", true);
            }
            X509Certificate cert = null;
            PublicKey publicKey = null;
            KeyInfo keyInfo = signature.getKeyInfo();
            if (keyInfo != null) {
                cert = keyInfo.getX509Certificate();
                if (cert != null) {
                    valid = signature.checkSignatureValue(cert);
                } else {
                    publicKey = keyInfo.getPublicKey();
                    if (publicKey != null) {
                        valid = signature.checkSignatureValue((Key)publicKey);
                    }
                }
            } else if (!this.keyInfoMustBeAvailable) {
                String user = this.getUserName(crypto, message);
                cert = SecurityUtils.getCertificates(crypto, user)[0];
                publicKey = cert.getPublicKey();
                valid = signature.checkSignatureValue(cert);
            }
            new TrustValidator().validateTrust(crypto, cert, publicKey);
            if (valid && this.persistSignature) {
                message.setContent(XMLSignature.class, signature);
                message.setContent(Element.class, signedElement);
            }
        }
        catch (Exception ex) {
            this.throwFault("Signature validation failed", ex);
        }
        if (!valid) {
            this.throwFault("Signature validation failed", null);
        }
        if (this.removeSignature) {
            if (!this.isEnveloping(root)) {
                Element signedEl = this.getSignedElement(root, ref);
                signedEl.removeAttribute("ID");
                root.removeChild(signatureElement);
            } else {
                Element actualBody = this.getActualBody(root);
                Document newDoc = DOMUtils.createDocument();
                newDoc.adoptNode(actualBody);
                root = actualBody;
            }
        }
        message.setContent(XMLStreamReader.class, new W3CDOMStreamReader(root));
        message.setContent(InputStream.class, null);
    }

    protected String getUserName(Crypto crypto, Message message) {
        SecurityContext sc = message.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        return SecurityUtils.getUserName(crypto, null);
    }

    private Element getActualBody(Element envelopingSigElement) {
        Element node;
        Element objectNode = this.getNode(envelopingSigElement, "http://www.w3.org/2000/09/xmldsig#", "Object", 0);
        if (objectNode == null) {
            this.throwFault("Object envelope is not available", null);
        }
        if ((node = DOMUtils.getFirstElement(objectNode)) == null) {
            this.throwFault("No signed data is found", null);
        }
        return node;
    }

    private Element getSignatureElement(Element sigParentElement) {
        if (this.isEnveloping(sigParentElement)) {
            return sigParentElement;
        }
        return DOMUtils.getFirstChildWithName(sigParentElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    protected boolean isEnveloping(Element root) {
        return "http://www.w3.org/2000/09/xmldsig#".equals(root.getNamespaceURI()) && "Signature".equals(root.getLocalName());
    }

    protected Reference getReference(XMLSignature sig) {
        int count = sig.getSignedInfo().getLength();
        if (count != 1) {
            this.throwFault("Multiple Signature Reference are not currently supported", null);
        }
        try {
            return sig.getSignedInfo().item(0);
        }
        catch (XMLSecurityException ex) {
            this.throwFault("Signature Reference is not available", (Exception)((Object)ex));
            return null;
        }
    }

    protected Element validateReference(Element root, Reference ref) {
        Element dm;
        Element signedEl;
        boolean enveloped = false;
        String refId = ref.getURI();
        if (!refId.startsWith("#") || refId.length() <= 1) {
            this.throwFault("Only local Signature References are supported", null);
        }
        if ((signedEl = this.getSignedElement(root, ref)) != null) {
            enveloped = signedEl == root;
        } else {
            this.throwFault("Signature Reference ID is invalid", null);
        }
        Transforms transforms = null;
        try {
            transforms = ref.getTransforms();
        }
        catch (XMLSecurityException ex) {
            this.throwFault("Signature transforms can not be obtained", (Exception)((Object)ex));
        }
        boolean c14TransformConfirmed = false;
        String c14TransformExpected = this.sigProps != null ? this.sigProps.getSignatureC14nTransform() : null;
        boolean envelopedConfirmed = false;
        for (int i = 0; i < transforms.getLength(); ++i) {
            try {
                Transform tr = transforms.item(i);
                if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(tr.getURI())) {
                    envelopedConfirmed = true;
                    continue;
                }
                if (c14TransformExpected == null || !c14TransformExpected.equals(tr.getURI())) continue;
                c14TransformConfirmed = true;
                continue;
            }
            catch (Exception ex) {
                this.throwFault("Problem accessing Transform instance", ex);
            }
        }
        if (enveloped && !envelopedConfirmed) {
            this.throwFault("Only enveloped signatures are currently supported", null);
        }
        if (c14TransformExpected != null && !c14TransformConfirmed) {
            this.throwFault("Transform Canonicalization is not supported", null);
        }
        if (this.sigProps != null && this.sigProps.getSignatureDigestAlgo() != null && (dm = DOMUtils.getFirstChildWithName(ref.getElement(), "http://www.w3.org/2000/09/xmldsig#", "DigestMethod")) != null && !dm.getAttribute("Algorithm").equals(this.sigProps.getSignatureDigestAlgo())) {
            this.throwFault("Signature Digest Algorithm is not supported", null);
        }
        return signedEl;
    }

    private Element getSignedElement(Element root, Reference ref) {
        String rootId = root.getAttribute("ID");
        String expectedID = ref.getURI().substring(1);
        if (!expectedID.equals(rootId)) {
            return AbstractXmlSigInHandler.findElementById(root, expectedID, true);
        }
        return root;
    }

    private static Element findElementById(Node startNode, String value, boolean checkMultipleElements) {
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        Element foundElement = null;
        String id = value;
        while (startNode != null) {
            if (startNode.getNodeType() == 1) {
                Element se = (Element)startNode;
                String attributeNS = se.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if ("".equals(attributeNS) || !id.equals(attributeNS)) {
                    attributeNS = se.getAttributeNS(null, "Id");
                }
                if ("".equals(attributeNS) || !id.equals(attributeNS)) {
                    attributeNS = se.getAttributeNS(null, "ID");
                }
                if (!"".equals(attributeNS) && id.equals(attributeNS)) {
                    if (!checkMultipleElements) {
                        return se;
                    }
                    if (foundElement == null) {
                        foundElement = se;
                    } else {
                        return null;
                    }
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public void setSignatureProperties(SignatureProperties properties) {
        this.sigProps = properties;
    }

    public void setKeyInfoMustBeAvailable(boolean use) {
        this.keyInfoMustBeAvailable = use;
    }
}

